/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.parser;

import io.xream.sqli.exception.ParsingException;
import io.xream.sqli.parser.BeanElement;
import io.xream.sqli.util.ParserUtil;
import io.xream.sqli.util.SqliStringUtil;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Parsed {
    private boolean isChecked = false;
    private Class clzz;
    private String tableName;
    private String originTable;
    private boolean isNoSpec = true;
    private String key;
    private Field keyField;
    private Field tagKeyField;
    private final List<Field> tagFieldList = new ArrayList<Field>();
    private List<BeanElement> beanElementList;
    private Map<String, BeanElement> elementMap = new HashMap<String, BeanElement>();
    private Map<String, String> propertyMapperMap = new HashMap<String, String>();
    private Map<String, String> mapperPropertyMapLower = new HashMap<String, String>();
    private boolean isNoCache;

    public Class getClzz() {
        return this.clzz;
    }

    public void setClzz(Class clzz) {
        this.clzz = clzz;
    }

    public Parsed(Class clzz) {
        this.clzz = clzz;
    }

    public BeanElement getElement(String property) {
        return this.elementMap.get(property);
    }

    public BeanElement getElementExisted(String property) {
        BeanElement be = this.elementMap.get(property);
        if (be == null) {
            throw new ParsingException("Not exist: " + property);
        }
        return be;
    }

    public String getKey() {
        return this.key;
    }

    public void setKeyField(Field keyField) {
        this.keyField = keyField;
        this.key = keyField.getName();
    }

    public Field getKeyField() {
        if (Objects.isNull(this.keyField)) {
            throw new ParsingException("No setting of PrimaryKey by @X.Key");
        }
        return this.keyField;
    }

    public Field getTagKeyField() {
        return this.tagKeyField;
    }

    public void setTagKeyField(Field tagKeyField) {
        this.tagKeyField = tagKeyField;
    }

    public List<Field> getTagFieldList() {
        return this.tagFieldList;
    }

    public boolean isAutoIncreaseId(Long keyOneValue) {
        Class<?> keyOneType = this.keyField.getType();
        return keyOneType != String.class && keyOneType != Date.class && keyOneType != Timestamp.class && (keyOneValue == null || keyOneValue == 0L);
    }

    public Long tryToGetLongKey(Object obj) {
        Long keyOneValue = 0L;
        Class<?> keyOneType = this.keyField.getType();
        if (keyOneType != String.class && keyOneType != Date.class && keyOneType != Timestamp.class) {
            try {
                Object keyValue = this.keyField.get(obj);
                if (keyValue != null) {
                    keyOneValue = Long.valueOf(keyValue.toString());
                }
            }
            catch (Exception e) {
                throw new ParsingException(e.getMessage());
            }
        }
        return keyOneValue;
    }

    public List<BeanElement> getBeanElementList() {
        return this.beanElementList;
    }

    public void setOriginTable(String originTable) {
        this.originTable = originTable;
    }

    public void reset(List<BeanElement> beanElementList) {
        this.beanElementList = beanElementList;
        this.propertyMapperMap.clear();
        this.elementMap.clear();
        this.mapperPropertyMapLower.clear();
        for (BeanElement e : this.beanElementList) {
            String property = e.getProperty();
            String mapper = e.getMapper();
            this.elementMap.put(property, e);
            this.propertyMapperMap.put(property, mapper);
            this.mapperPropertyMapLower.put(mapper.toLowerCase(), property);
        }
    }

    public String getTableName(String alia) {
        if (SqliStringUtil.isNullOrEmpty(alia)) {
            return this.tableName;
        }
        if (!alia.equalsIgnoreCase(this.getClzName())) {
            return alia;
        }
        return this.tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = ParserUtil.filterSQLKeyword(tableName);
    }

    public String getClzName() {
        return this.clzz.getSimpleName();
    }

    public boolean isNoCache() {
        return this.isNoCache;
    }

    public void setNoCache(boolean isNoCache) {
        this.isNoCache = isNoCache;
    }

    public String getMapper(String property) {
        return this.propertyMapperMap.get(property);
    }

    public String getPropertyByLower(String mapper) {
        return this.mapperPropertyMapLower.get(mapper.toLowerCase());
    }

    public Map<String, String> getPropertyMapperMap() {
        return this.propertyMapperMap;
    }

    public boolean isNoSpec() {
        return this.isNoSpec;
    }

    public void setNoSpec(boolean isNoSpec2) {
        this.isNoSpec = isNoSpec2;
    }

    public String toString() {
        return "Parsed{, isChecked=" + this.isChecked + ", clz=" + this.clzz + ", tableName='" + this.tableName + '\'' + ", originTable='" + this.originTable + '\'' + ", isNoSpec=" + this.isNoSpec + ", key=" + this.key + ", keyField=" + this.keyField + ", beanElementList=" + this.beanElementList + ", elementMap=" + this.elementMap + ", propertyMapperMap=" + this.propertyMapperMap + ", isNoCache=" + this.isNoCache + '}';
    }
}

