/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.mapping;

import io.xream.sqli.mapping.Script;
import java.util.HashSet;
import java.util.Set;

public interface SqlNormalizer
extends Script {
    public static final Set<String> OP_SET = new HashSet(){
        {
            this.add("=");
            this.add("!");
            this.add(">");
            this.add("<");
            this.add("+");
            this.add("-");
            this.add("*");
            this.add("/");
            this.add(";");
            this.add(":");
        }
    };

    default public void normalizeFunctionParentThesis(int idx, String strEle, StringBuilder valueSb, String handwritten) {
        if (strEle.equals("(") && idx - 1 > -1) {
            String pre = String.valueOf(handwritten.charAt(idx - 1));
            if (pre.equals(" ") || OP_SET.contains(pre)) {
                valueSb.append(" ");
            }
        } else {
            valueSb.append(" ");
        }
    }

    default public int normalizeParentThesis(int idx, int length, String strEle, StringBuilder valueSb, String handwritten) {
        String nextOp;
        this.normalizeFunctionParentThesis(idx, strEle, valueSb, handwritten);
        valueSb.append(strEle);
        while (idx + 1 < length && (nextOp = String.valueOf(handwritten.charAt(idx + 1))).equals(strEle)) {
            valueSb.append(nextOp);
            ++idx;
        }
        valueSb.append(" ");
        return idx;
    }

    default public int normalizeOp(int idx, int length, String strEle, StringBuilder valueSb, String handwritten) {
        String nextOp;
        valueSb.append(" ").append(strEle);
        if (idx + 1 < length && OP_SET.contains(nextOp = String.valueOf(handwritten.charAt(idx + 1)))) {
            valueSb.append(nextOp);
            ++idx;
        }
        return idx;
    }

    default public String normalizeSql(String handwritten) {
        StringBuilder valueSb = new StringBuilder();
        boolean ignored = false;
        int length = handwritten.length();
        for (int j = 0; j < length; ++j) {
            String strEle = String.valueOf(handwritten.charAt(j));
            if (" ".equals(strEle)) {
                ignored = true;
                continue;
            }
            if (strEle.equals("(") || strEle.equals(")")) {
                j = this.normalizeParentThesis(j, length, strEle, valueSb, handwritten);
                continue;
            }
            if (OP_SET.contains(strEle)) {
                j = this.normalizeOp(j, length, strEle, valueSb, handwritten);
                continue;
            }
            if (ignored) {
                valueSb.append(" ");
            }
            valueSb.append(strEle);
            ignored = false;
        }
        return valueSb.toString();
    }
}

