/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.exception;

import io.xream.sqli.exception.PersistenceException;
import io.xream.sqli.exception.QueryException;
import io.xream.sqli.util.SqliExceptionUtil;
import org.slf4j.Logger;

public class ExceptionTranslator {
    private ExceptionTranslator() {
    }

    public static PersistenceException onRollback(Object obj, Exception e, Logger logger) {
        Throwable t = SqliExceptionUtil.unwrapThrowable(e);
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        return new PersistenceException(e);
    }

    public static QueryException onQuery(Exception e, Logger logger) {
        Throwable t = SqliExceptionUtil.unwrapThrowable(e);
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        logger.error(SqliExceptionUtil.getMessage(t));
        return new QueryException(e);
    }
}

