/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.builder;

import io.xream.sqli.builder.ConditionBuilder;
import io.xream.sqli.builder.JoinFrom;
import io.xream.sqli.builder.JoinType;
import io.xream.sqli.builder.On;
import io.xream.sqli.builder.Op;
import io.xream.sqli.builder.SourceScript;
import io.xream.sqli.builder.SqlScript;
import io.xream.sqli.builder.Sub;
import io.xream.sqli.exception.NotSupportedException;
import io.xream.sqli.exception.ParsingException;
import io.xream.sqli.parser.Parser;
import io.xream.sqli.util.SqliStringUtil;
import java.util.ArrayList;
import java.util.List;

public interface SourceScriptBuilder {
    public SourceScriptBuilder source(String var1);

    public SourceScriptBuilder sub(Sub var1);

    public SourceScriptBuilder with(Sub var1);

    public SourceScriptBuilder alia(String var1);

    public SourceScriptBuilder join(JoinType var1);

    public SourceScriptBuilder join(String var1);

    public SourceScriptBuilder on(String var1, JoinFrom var2);

    public SourceScriptBuilder on(String var1, Op var2, JoinFrom var3);

    public ConditionBuilder more();

    public static void checkSourceAndAlia(List<SourceScript> list) {
        for (SourceScript sourceScript : list) {
            String source = sourceScript.getSource();
            if (SqliStringUtil.isNotNull(source) && !Parser.contains(source)) {
                String tip = "";
                tip = sourceScript.getJoinType() != null ? tip + sourceScript.getJoinType().name().replace("_", " ") : (SqliStringUtil.isNotNull(sourceScript.getJoinStr()) ? tip + sourceScript.getJoinStr() : tip + "FROM");
                throw new ParsingException(tip + " " + source);
            }
            String alia = sourceScript.getAlia();
            if (source == null || alia == null || alia.equals(source) || !Parser.contains(alia)) continue;
            throw new NotSupportedException("not support table alia = firstLetterLower(parsedEntityName), name+alia: " + source + " " + alia);
        }
    }

    public static List<SourceScript> parse(List<String> sourceScriptsSplittedList) {
        ArrayList<SourceScript> list = new ArrayList<SourceScript>();
        SourceScript sourceScript = null;
        int size = sourceScriptsSplittedList.size();
        block20: for (int i = 0; i < size; ++i) {
            String str = sourceScriptsSplittedList.get(i);
            String strUpper = str.toUpperCase();
            if (strUpper.equals("AND") || strUpper.equals("OR")) {
                throw new IllegalArgumentException("SourceScript String does not support ON AND | OR, try to call builder.sourceScript()");
            }
            if ("FROM".equals(strUpper)) continue;
            switch (strUpper) {
                case "INNER": {
                    sourceScript = SourceScriptBuilder.createAndGet(list);
                    sourceScript.setJoinType(JoinType.INNER_JOIN);
                    ++i;
                    continue block20;
                }
                case "LEFT": {
                    sourceScript = SourceScriptBuilder.createAndGet(list);
                    sourceScript.setJoinType(JoinType.LEFT_JOIN);
                    ++i;
                    continue block20;
                }
                case "RIGHT": {
                    sourceScript = SourceScriptBuilder.createAndGet(list);
                    sourceScript.setJoinType(JoinType.RIGHT_JOIN);
                    ++i;
                    continue block20;
                }
                case "OUTER": {
                    sourceScript = SourceScriptBuilder.createAndGet(list);
                    sourceScript.setJoinType(JoinType.OUTER_JOIN);
                    ++i;
                    continue block20;
                }
                case "FULL": {
                    sourceScript = SourceScriptBuilder.createAndGet(list);
                    sourceScript.setJoinType(JoinType.JOIN);
                    ++i;
                    continue block20;
                }
                case "JOIN": {
                    sourceScript = SourceScriptBuilder.createAndGet(list);
                    sourceScript.setJoinType(JoinType.JOIN);
                    continue block20;
                }
                case ",": {
                    sourceScript = SourceScriptBuilder.createAndGet(list);
                    sourceScript.setJoinType(JoinType.COMMA);
                    continue block20;
                }
                case "ON": {
                    String selfKey = sourceScriptsSplittedList.get(++i);
                    String op = sourceScriptsSplittedList.get(++i);
                    String fromKey = sourceScriptsSplittedList.get(++i);
                    if (fromKey.startsWith(sourceScript.getSource()) || sourceScript.getAlia() != null && fromKey.startsWith(sourceScript.getAlia())) {
                        String temp = selfKey;
                        selfKey = fromKey;
                        fromKey = temp;
                    }
                    int selfIndex = selfKey.indexOf(".");
                    int fromIndex = fromKey.indexOf(".");
                    JoinFrom joinFrom = new JoinFrom();
                    joinFrom.setAlia(fromKey.substring(0, fromIndex));
                    joinFrom.setKey(fromKey.substring(fromIndex + 1));
                    On on = new On();
                    on.setKey(selfKey.substring(selfIndex + 1));
                    on.setOp(op);
                    on.setJoinFrom(joinFrom);
                    sourceScript.setOn(on);
                    continue block20;
                }
                default: {
                    String tryAlia;
                    if (sourceScript == null) {
                        sourceScript = SourceScriptBuilder.createAndGet(list);
                    }
                    sourceScript.setSource(str);
                    if (i >= size - 1 || SqlScript.SOURCE_SCRIPT.contains((tryAlia = sourceScriptsSplittedList.get(i + 1)).toUpperCase())) continue block20;
                    sourceScript.setAlia(tryAlia);
                    ++i;
                }
            }
        }
        return list;
    }

    public static List<String> split(String script) {
        String[] opArrTwo = new String[]{"!=", "<>", "<=", ">="};
        String[] opArrTwoTemp = new String[]{"&ne", "&ne", "&lte", "&gte"};
        String[] opArrOne = new String[]{"=", "<", ">"};
        String sourceScript = script;
        boolean flag = false;
        for (int i = 0; i < 4; ++i) {
            if (!sourceScript.contains(opArrTwo[i])) continue;
            flag = true;
            sourceScript = sourceScript.replace(opArrTwo[i], opArrTwoTemp[i]);
        }
        for (String op : opArrOne) {
            if (!sourceScript.contains(op)) continue;
            sourceScript = sourceScript.replace(op, " " + op + " ");
        }
        if (flag) {
            for (int i = 0; i < 4; ++i) {
                if (!sourceScript.contains(opArrTwoTemp[i])) continue;
                sourceScript = sourceScript.replace(opArrTwoTemp[i], " " + opArrTwo[i] + " ");
            }
        }
        if (sourceScript.contains(",")) {
            sourceScript = sourceScript.replace(",", " , ");
        }
        String[] arr = sourceScript.split(" ");
        ArrayList<String> list = new ArrayList<String>();
        for (String str : arr) {
            if (!SqliStringUtil.isNotNull(str)) continue;
            list.add(str);
        }
        return list;
    }

    public static SourceScript createAndGet(List<SourceScript> list) {
        SourceScript sourceScript = new SourceScript();
        list.add(sourceScript);
        return sourceScript;
    }
}

