/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.builder;

import io.xream.sqli.exception.ParsingException;
import io.xream.sqli.exception.PersistenceException;
import io.xream.sqli.parser.BeanElement;
import io.xream.sqli.parser.Parsed;
import io.xream.sqli.util.EnumUtil;
import io.xream.sqli.util.SqliExceptionUtil;
import io.xream.sqli.util.SqliJsonUtil;
import java.lang.reflect.Field;
import java.util.List;

public interface DialectSupport {
    public String getKey();

    public Object convertJsonToPersist(Object var1);

    public String getAlterTableUpdate();

    public String getAlterTableDelete();

    public String getCommandUpdate();

    public String getCommandDelete();

    public String getLimitOne();

    public String getInsertTagged();

    public Object filterValue(Object var1);

    public void filterTags(List<BeanElement> var1, List<Field> var2);

    public List<Object> objectToListForCreate(Object var1, Parsed var2);

    default public void objectToListForCreate(List<Object> list, Object obj, List<BeanElement> tempList) {
        try {
            for (BeanElement ele : tempList) {
                Object value = ele.getGetMethod().invoke(obj, new Object[0]);
                Class clz = ele.getClz();
                if (value == null) {
                    if (EnumUtil.isEnum(clz)) {
                        throw new PersistenceException("ENUM CAN NOT NULL, property:" + obj.getClass().getName() + "." + ele.getProperty());
                    }
                    list.add(null);
                    continue;
                }
                if (ele.isJson()) {
                    String str = SqliJsonUtil.toJson(value);
                    Object jsonStr = this.convertJsonToPersist(str);
                    list.add(jsonStr);
                    continue;
                }
                if (EnumUtil.isEnum(clz)) {
                    list.add(EnumUtil.serialize((Enum)value));
                    continue;
                }
                value = this.filterValue(value);
                list.add(value);
            }
        }
        catch (Exception e) {
            SqliExceptionUtil.throwRuntimeExceptionFirst(e);
            throw new ParsingException(e);
        }
    }
}

