/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.support;

import io.xream.sqli.builder.Bb;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public final class TimeSupport {
    public static Object afterReadTime(Class propertyType, Object obj) {
        if (obj instanceof LocalDateTime) {
            if (propertyType == Date.class) {
                Instant instant = ((LocalDateTime)obj).atZone(ZoneId.systemDefault()).toInstant();
                obj = Date.from(instant);
            } else if (propertyType == Timestamp.class) {
                Instant instant = ((LocalDateTime)obj).atZone(ZoneId.systemDefault()).toInstant();
                obj = Timestamp.from(instant);
            } else if (propertyType == LocalDate.class) {
                obj = ((LocalDateTime)obj).toLocalDate();
            }
        } else if (obj instanceof Timestamp) {
            if (propertyType == LocalDateTime.class) {
                obj = Instant.ofEpochMilli(((Timestamp)obj).getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
            } else if (propertyType == Date.class) {
                obj = new Date(((Timestamp)obj).getTime());
            } else if (propertyType == LocalDate.class) {
                obj = Instant.ofEpochMilli(((Timestamp)obj).getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
            }
        }
        return obj;
    }

    public static boolean testWriteNumberValueToTime(Class propertyType, Bb bb) {
        if (propertyType == LocalDateTime.class) {
            Object v = bb.getValue();
            if (v instanceof Long || v instanceof Integer) {
                if (Long.valueOf(v.toString()) == 0L) {
                    bb.setValue(null);
                } else {
                    LocalDateTime time = Instant.ofEpochMilli(TimeSupport.toLongValue(v)).atZone(ZoneId.systemDefault()).toLocalDateTime();
                    bb.setValue(time);
                }
            }
            return true;
        }
        if (propertyType == Date.class) {
            Object v = bb.getValue();
            if (v instanceof Long || v instanceof Integer) {
                if (Long.valueOf(v.toString()) == 0L) {
                    bb.setValue(null);
                } else {
                    bb.setValue(new Date(TimeSupport.toLongValue(v)));
                }
            }
            return true;
        }
        if (propertyType == Timestamp.class) {
            Object v = bb.getValue();
            if (v instanceof Long || v instanceof Integer) {
                if (Long.valueOf(v.toString()) == 0L) {
                    bb.setValue(null);
                } else {
                    bb.setValue(new Timestamp(TimeSupport.toLongValue(v)));
                }
            }
            return true;
        }
        if (propertyType == LocalDate.class) {
            Object v = bb.getValue();
            if (v instanceof Long || v instanceof Integer) {
                if (Long.valueOf(v.toString()) == 0L) {
                    bb.setValue(null);
                } else {
                    LocalDate date = Instant.ofEpochMilli(TimeSupport.toLongValue(v)).atZone(ZoneId.systemDefault()).toLocalDate();
                    bb.setValue(date);
                }
            }
            return true;
        }
        return false;
    }

    private static long toLongValue(Object v) {
        if (v instanceof Integer) {
            return ((Integer)v).intValue();
        }
        return (Long)v;
    }
}

