/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.MapType;
import io.xream.sqli.util.SqliExceptionUtil;
import io.xream.sqli.util.SqliStringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqliJsonUtil {
    private static final Logger logger = LoggerFactory.getLogger(SqliJsonUtil.class);
    private static ObjectMapper objectMapper;

    private SqliJsonUtil() {
    }

    protected static void config(ObjectMapper om) {
        objectMapper = om;
    }

    public static String toJson(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return obj.toString();
        }
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            logger.info(SqliExceptionUtil.getMessage(e));
            return null;
        }
    }

    public static <T> T toObject(String json, Class<T> clzz) {
        if (SqliStringUtil.isNullOrEmpty(json)) {
            return null;
        }
        if (clzz == String.class) {
            return (T)json;
        }
        try {
            return (T)objectMapper.readValue(json, clzz);
        }
        catch (Exception e) {
            logger.info(SqliExceptionUtil.getMessage(e));
            return null;
        }
    }

    public static <T> T toObject(Object jsonObject, Class<T> clzz) {
        if (jsonObject == null) {
            return null;
        }
        if (clzz == String.class) {
            return (T)jsonObject;
        }
        try {
            return (T)objectMapper.convertValue(jsonObject, clzz);
        }
        catch (Exception e) {
            logger.info(SqliExceptionUtil.getMessage(e));
            return null;
        }
    }

    public static <E> List<E> toList(Object jsonObject, Class<E> clzz) {
        if (jsonObject == null) {
            return null;
        }
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{clzz});
        try {
            return (List)objectMapper.convertValue(jsonObject, javaType);
        }
        catch (Exception e) {
            logger.info(SqliExceptionUtil.getMessage(e));
            return null;
        }
    }

    public static <E> List<E> toList(String json, Class<E> clzz) {
        if (SqliStringUtil.isNullOrEmpty(json)) {
            return null;
        }
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{clzz});
        try {
            return (List)objectMapper.readValue(json, javaType);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            return null;
        }
    }

    public static <K, V> Map<K, V> toMap(String json, Class<K> kClzz, Class<V> vClZZ) {
        if (SqliStringUtil.isNullOrEmpty(json)) {
            return null;
        }
        try {
            MapType mapType = objectMapper.getTypeFactory().constructMapType(HashMap.class, kClzz, vClZZ);
            return (Map)objectMapper.readValue(json, (JavaType)mapType);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            return null;
        }
    }

    public static Map toMap(String json) {
        if (SqliStringUtil.isNullOrEmpty(json)) {
            return null;
        }
        try {
            return (Map)objectMapper.readValue(json, Map.class);
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            return null;
        }
    }

    static {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            objectMapper.configure(DeserializationFeature.WRAP_EXCEPTIONS, true);
            objectMapper.configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, true);
        }
    }

    public static interface Customizer {
        public ObjectMapper customize();

        default public void onStarted(ObjectMapper objectMapper) {
            SqliJsonUtil.config(objectMapper);
        }
    }
}

