/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.builder.internal;

import io.xream.sqli.builder.Criteria;
import io.xream.sqli.page.Page;
import java.util.List;

public final class PageBuilderHelper {
    private PageBuilderHelper() {
    }

    public static <T> Page<T> build(Criteria criteria, List<T> list, TotalRows totalRows) {
        long count = 0L;
        int rows = criteria.getRows();
        int page = criteria.getPage();
        if (!criteria.isTotalRowsIgnored()) {
            int size = list.size();
            if (page == 0) {
                count = size;
            } else if (size > 0) {
                try {
                    count = totalRows.count();
                }
                catch (Exception exception) {}
            }
        } else {
            count = -1L;
        }
        Page<T> pagination = new Page<T>();
        pagination.setClzz(criteria.getClzz());
        pagination.setPage(page == 0 ? 1 : page);
        pagination.setRows(rows == 0 ? Integer.MAX_VALUE : rows);
        pagination.setSortList(criteria.getSortList());
        pagination.setTotalRowsIgnored(criteria.isTotalRowsIgnored());
        pagination.setList(list);
        pagination.setTotalRows(count);
        return pagination;
    }

    public static interface TotalRows {
        public long count();
    }
}

