/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.builder;

import io.xream.sqli.builder.Bb;
import io.xream.sqli.builder.Op;
import io.xream.sqli.mapping.SqlNormalizer;
import io.xream.sqli.util.EnumUtil;
import io.xream.sqli.util.SqliStringUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class ConditionCriteriaBuilder
implements SqlNormalizer {
    private ConditionCriteriaBuilder instance = this;
    private transient List<Bb> bbList;
    private transient boolean isOr;
    private transient List<Bb> tempList;
    private transient List<List<Bb>> subsList;

    protected ConditionCriteriaBuilder() {
    }

    protected ConditionCriteriaBuilder(List<Bb> bbList) {
        this.instance.bbList = bbList;
    }

    protected void init(List<Bb> bbList) {
        this.bbList = bbList;
    }

    private List<List<Bb>> getSubsList() {
        if (this.subsList == null) {
            this.subsList = new LinkedList<List<Bb>>();
        }
        return this.subsList;
    }

    public static ConditionCriteriaBuilder build(List<Bb> bbList) {
        return new ConditionCriteriaBuilder(bbList);
    }

    public ConditionCriteriaBuilder eq(String property, Object value) {
        return this.doGle(Op.EQ, property, value);
    }

    public ConditionCriteriaBuilder lt(String property, Object value) {
        return this.doGle(Op.LT, property, value);
    }

    public ConditionCriteriaBuilder lte(String property, Object value) {
        return this.doGle(Op.LTE, property, value);
    }

    public ConditionCriteriaBuilder gt(String property, Object value) {
        return this.doGle(Op.GT, property, value);
    }

    public ConditionCriteriaBuilder gte(String property, Object value) {
        return this.doGle(Op.GTE, property, value);
    }

    public ConditionCriteriaBuilder ne(String property, Object value) {
        return this.doGle(Op.NE, property, value);
    }

    public ConditionCriteriaBuilder like(String property, String value) {
        if (SqliStringUtil.isNullOrEmpty(value)) {
            this.isOr();
            return this.instance;
        }
        String likeValue = "%" + value + "%";
        return this.doLike(Op.LIKE, property, likeValue);
    }

    public ConditionCriteriaBuilder likeRight(String property, String value) {
        if (SqliStringUtil.isNullOrEmpty(value)) {
            this.isOr();
            return this.instance;
        }
        String likeValue = value + "%";
        return this.doLike(Op.LIKE, property, likeValue);
    }

    public ConditionCriteriaBuilder notLike(String property, String value) {
        if (SqliStringUtil.isNullOrEmpty(value)) {
            this.isOr();
            return this.instance;
        }
        String likeValue = "%" + value + "%";
        return this.doLike(Op.NOT_LIKE, property, likeValue);
    }

    public ConditionCriteriaBuilder in(String property, List<? extends Object> list) {
        return this.doIn(Op.IN, property, list);
    }

    public ConditionCriteriaBuilder nin(String property, List<? extends Object> list) {
        return this.doIn(Op.NOT_IN, property, list);
    }

    public ConditionCriteriaBuilder nonNull(String property) {
        return this.doNull(Op.IS_NOT_NULL, property);
    }

    public ConditionCriteriaBuilder isNull(String property) {
        return this.doNull(Op.IS_NULL, property);
    }

    public ConditionCriteriaBuilder x(String sqlSegment, Object ... values) {
        if (SqliStringUtil.isNullOrEmpty(sqlSegment)) {
            this.isOr();
            return this.instance;
        }
        String sql = this.normalizeSql(sqlSegment);
        Object[] arr = null;
        if (values != null) {
            int length = values.length;
            arr = new Object[length];
            for (int i = 0; i < length; ++i) {
                arr[i] = EnumUtil.filterInComplexScriptSimply(values[i]);
            }
        }
        Bb bb = new Bb(this.isOr());
        bb.setP(Op.X);
        bb.setKey(sql);
        bb.setValue(arr);
        this.add(bb);
        return this.instance;
    }

    public ConditionCriteriaBuilder and() {
        this.isOr = false;
        return this.instance;
    }

    public ConditionCriteriaBuilder or() {
        this.isOr = true;
        return this.instance;
    }

    public ConditionCriteriaBuilder beginSub() {
        Bb bb = new Bb(this.isOr());
        bb.setP(Op.SUB);
        ArrayList<Bb> subList = new ArrayList<Bb>();
        bb.setSubList(subList);
        this.add(bb);
        this.tempList = subList;
        this.getSubsList().add(subList);
        return this.instance;
    }

    public ConditionCriteriaBuilder endSub() {
        this.isOr();
        int size = this.getSubsList().size();
        if (--size >= 0) {
            this.getSubsList().remove(size);
        }
        this.tempList = --size >= 0 ? this.getSubsList().get(size) : null;
        return this.instance;
    }

    private ConditionCriteriaBuilder doGle(Op p, String property, Object value) {
        if (value == null) {
            this.isOr();
            return this.instance;
        }
        if (SqliStringUtil.isNullOrEmpty(value)) {
            this.isOr();
            return this.instance;
        }
        Bb bb = new Bb(this.isOr());
        bb.setP(p);
        bb.setKey(property);
        bb.setValue(value);
        this.add(bb);
        return this.instance;
    }

    private ConditionCriteriaBuilder doLike(Op p, String property, String likeWalue) {
        Bb bb = new Bb(this.isOr());
        bb.setP(p);
        bb.setKey(property);
        bb.setValue(likeWalue);
        this.add(bb);
        return this.instance;
    }

    private ConditionCriteriaBuilder doIn(Op p, String property, List<? extends Object> list) {
        if (list == null || list.isEmpty()) {
            this.isOr();
            return this.instance;
        }
        ArrayList<Object> tempList = new ArrayList<Object>();
        for (Object object : list) {
            if (Objects.isNull(object) || tempList.contains(object)) continue;
            tempList.add(object);
        }
        if (tempList.isEmpty()) {
            this.isOr();
            return this.instance;
        }
        Bb bb = new Bb(this.isOr());
        bb.setP(p);
        bb.setKey(property);
        bb.setValue(tempList);
        this.add(bb);
        return this.instance;
    }

    private ConditionCriteriaBuilder doNull(Op p, String property) {
        if (SqliStringUtil.isNullOrEmpty(property)) {
            this.isOr();
            return this.instance;
        }
        Bb bb = new Bb(this.isOr());
        bb.setP(p);
        bb.setKey(property);
        bb.setValue((Object)p);
        this.add(bb);
        return this.instance;
    }

    private boolean isOr() {
        if (this.isOr) {
            this.isOr = false;
            return true;
        }
        return false;
    }

    private void add(Bb bb) {
        if (this.tempList == null) {
            this.bbList.add(bb);
        } else {
            this.tempList.add(bb);
        }
    }
}

