/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.exception;

import io.xream.sqli.exception.PersistenceException;
import io.xream.sqli.exception.QueryException;
import io.xream.sqli.util.SqliExceptionUtil;
import org.slf4j.Logger;

public class ExceptionTranslator {
    private ExceptionTranslator() {
    }

    public static PersistenceException onRollback(Object obj, Exception e, Logger logger) {
        Throwable t = SqliExceptionUtil.unwrapThrowable(e);
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        String msg = SqliExceptionUtil.getMessage(t);
        String objStr = obj == null ? "" : obj.toString();
        String logStr = objStr + ", Exception: " + msg;
        String eStr = objStr + ", \nException: " + msg;
        logger.error(logStr);
        return new PersistenceException(eStr);
    }

    public static QueryException onQuery(Exception e, Logger logger) {
        Throwable t = SqliExceptionUtil.unwrapThrowable(e);
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        String msg = SqliExceptionUtil.getMessage(t);
        logger.error(msg);
        return new QueryException(msg);
    }
}

