/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.builder.internal;

import io.xream.sqli.builder.Bb;
import io.xream.sqli.builder.Criteria;
import io.xream.sqli.builder.CriteriaCondition;
import io.xream.sqli.builder.CriteriaToSql;
import io.xream.sqli.builder.DialectSupport;
import io.xream.sqli.builder.Direction;
import io.xream.sqli.builder.FunctionResultKey;
import io.xream.sqli.builder.Having;
import io.xream.sqli.builder.KV;
import io.xream.sqli.builder.Op;
import io.xream.sqli.builder.Reduce;
import io.xream.sqli.builder.ReduceType;
import io.xream.sqli.builder.RefreshCondition;
import io.xream.sqli.builder.ResultKeyGenerator;
import io.xream.sqli.builder.Sort;
import io.xream.sqli.builder.SourceScript;
import io.xream.sqli.builder.SourceScriptBuilder;
import io.xream.sqli.builder.SourceScriptOptimizable;
import io.xream.sqli.builder.SqlBuildingAttached;
import io.xream.sqli.builder.SqlBuilt;
import io.xream.sqli.exception.CriteriaSyntaxException;
import io.xream.sqli.exception.ParsingException;
import io.xream.sqli.exception.SqlBuildException;
import io.xream.sqli.filter.BaseTypeFilter;
import io.xream.sqli.mapping.Mappable;
import io.xream.sqli.parser.BeanElement;
import io.xream.sqli.parser.Parsed;
import io.xream.sqli.parser.Parser;
import io.xream.sqli.support.ResultMapSingleSourceSupport;
import io.xream.sqli.support.TimestampSupport;
import io.xream.sqli.util.JsonWrapper;
import io.xream.sqli.util.SqliStringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class DefaultCriteriaToSql
implements CriteriaToSql,
ResultKeyGenerator,
SourceScriptOptimizable,
ResultMapSingleSourceSupport {
    private static CriteriaToSql instance;

    private DefaultCriteriaToSql() {
    }

    public static CriteriaToSql newInstance() {
        if (instance == null) {
            instance = new DefaultCriteriaToSql();
            return instance;
        }
        return null;
    }

    @Override
    public String toSql(CriteriaCondition criteriaCondition, List<Object> valueList, Mappable mappable) {
        if (Objects.isNull(criteriaCondition)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List<Bb> bbList = criteriaCondition.getBbList();
        if (bbList.isEmpty()) {
            return "";
        }
        this.filter(bbList, mappable);
        if (bbList.isEmpty()) {
            return "";
        }
        this.pre(valueList, bbList);
        bbList.get(0).setC(Op.WHERE);
        this.buildConditionSql(sb, bbList, mappable);
        return sb.toString();
    }

    @Override
    public void toSql(boolean isSub, Criteria criteria, SqlBuilt sqlBuilt, SqlBuildingAttached sqlBuildingAttached) {
        SqlBuilder sqlBuilder = SqlBuilder.get();
        this.parseAlia(criteria, sqlBuilder);
        this.filter0(criteria);
        this.select(sqlBuilder, this.resultKey(sqlBuilder, criteria, sqlBuildingAttached));
        this.forceIndex(isSub, sqlBuilder, criteria);
        this.sourceScriptPre(criteria, sqlBuildingAttached);
        this.condition(sqlBuilder, criteria.getBbList(), criteria, sqlBuildingAttached.getValueList());
        this.count(isSub, criteria.isTotalRowsIgnored(), sqlBuilder);
        this.groupBy(sqlBuilder, criteria);
        this.having(sqlBuilder, criteria);
        this.sort(sqlBuilder, criteria);
        this.sourceScript(sqlBuilder, criteria);
        this.sqlArr(isSub, criteria.isTotalRowsIgnored(), sqlBuilt, sqlBuildingAttached, sqlBuilder);
    }

    private String sourceScriptOfRefresh(Parsed parsed, RefreshCondition refreshCondition) {
        String sourceScript = refreshCondition.getSourceScript();
        if (SqliStringUtil.isNullOrEmpty(sourceScript)) {
            return parsed.getTableName();
        }
        this.parseAliaFromRefresh(refreshCondition);
        String str = this.normalizeSql(sourceScript);
        StringBuilder sb = new StringBuilder();
        this.mapping(reg -> str.split(reg), refreshCondition, sb);
        return sb.toString();
    }

    @Override
    public String toSql(Parsed parsed, RefreshCondition refreshCondition, DialectSupport dialectSupport) {
        String sourceScript = this.sourceScriptOfRefresh(parsed, refreshCondition);
        StringBuilder sb = new StringBuilder();
        sb.append(dialectSupport.getAlterTableUpdate()).append(" ").append(sourceScript).append(" ").append(dialectSupport.getCommandUpdate()).append(" ");
        this.concatRefresh(sb, parsed, refreshCondition, dialectSupport);
        String conditionSql = this.toSql(refreshCondition, refreshCondition.getValueList(), refreshCondition);
        sb.append(conditionSql);
        String sql = sb.toString();
        if (sql.contains("SET  WHERE")) {
            throw new SqlBuildException(sql);
        }
        return sql;
    }

    private void concatRefresh(StringBuilder sb, Parsed parsed, RefreshCondition refreshCondition, DialectSupport dialectSupport) {
        List<Bb> refreshList = refreshCondition.getRefreshList();
        ArrayList<Object> refreshValueList = new ArrayList<Object>();
        boolean isNotFirst = false;
        for (Bb bb : refreshList) {
            String key;
            if (bb.getP() == Op.X) {
                if (isNotFirst) {
                    sb.append(",").append(" ");
                }
                isNotFirst = true;
                key = bb.getKey();
                String str = key.toString();
                String sql = this.normalizeSql(str);
                this.mapping(reg -> sql.split(reg), refreshCondition, sb);
                continue;
            }
            key = bb.getKey();
            if (key.contains("?")) {
                if (isNotFirst) {
                    sb.append(",").append(" ");
                }
                isNotFirst = true;
                String sql = this.normalizeSql(key);
                this.mapping(reg -> sql.split(reg), refreshCondition, sb);
            } else {
                Object v;
                Parsed p;
                String k = null;
                if (key.contains(".")) {
                    String[] arr = key.split("\\.");
                    p = Parser.get(arr[0]);
                    if (p == null) {
                        throw new ParsingException("can not find the clzz: " + arr[0]);
                    }
                    k = arr[1];
                } else {
                    k = key;
                    p = parsed;
                }
                BeanElement be = p.getElement(k);
                if (be == null) {
                    throw new ParsingException("can not find the property " + key + " of " + parsed.getClzName());
                }
                TimestampSupport.testNumberValueToDate(be.getClz(), bb);
                if (SqliStringUtil.isNullOrEmpty(String.valueOf(bb.getValue())) || BaseTypeFilter.isBaseType(key, bb.getValue(), parsed)) continue;
                if (isNotFirst) {
                    sb.append(",").append(" ");
                }
                isNotFirst = true;
                String mapper = this.mapping(key, refreshCondition);
                sb.append(mapper);
                sb.append(" = ?");
                if (be.isJson() && (v = bb.getValue()) != null) {
                    String str = JsonWrapper.toJson(v);
                    Object jsonStr = dialectSupport.convertJsonToPersist(str);
                    bb.setValue(jsonStr);
                }
            }
            refreshValueList.add(bb.getValue());
        }
        if (!refreshValueList.isEmpty()) {
            refreshCondition.getValueList().addAll(0, refreshValueList);
        }
    }

    private void sqlArr(boolean isSub, boolean isTotalRowsIgnored, SqlBuilt sqlBuilt, SqlBuildingAttached sqlBuildingAttached, SqlBuilder sb) {
        StringBuilder sqlSb;
        if (!isSub) {
            for (SqlBuilt sub : sqlBuildingAttached.getSubList()) {
                int start = sb.sbSource.indexOf("${SUB}");
                sb.sbSource.replace(start, start + "${SUB}".length(), "(" + sub.getSql().toString() + ")");
            }
            if (!isTotalRowsIgnored) {
                sqlSb = new StringBuilder();
                sqlSb.append("SELECT").append(" ").append(sb.countSql).append(" ").append((CharSequence)sb.sbSource).append((CharSequence)sb.countCondition);
                sqlBuilt.setCountSql(sqlSb.toString());
            }
        }
        sqlSb = new StringBuilder();
        sqlSb.append((CharSequence)sb.sbResult).append((CharSequence)sb.sbSource).append((CharSequence)sb.sbCondition);
        sqlBuilt.setSql(sqlSb);
    }

    private String resultKey(SqlBuilder sqlBuilder, Criteria criteria, SqlBuildingAttached sqlBuildingAttached) {
        String script;
        List<FunctionResultKey> functionList;
        List<KV> resultListAssignedAliaList;
        List<String> resultList;
        List<Reduce> reduceList;
        if (!(criteria instanceof Criteria.ResultMapCriteria)) {
            return "*";
        }
        boolean flag = false;
        Criteria.ResultMapCriteria resultMapped = (Criteria.ResultMapCriteria)criteria;
        StringBuilder columnBuilder = new StringBuilder();
        Map<String, String> mapperPropertyMap = resultMapped.getMapperPropertyMap();
        if (Objects.nonNull(resultMapped.getDistinct())) {
            columnBuilder.append("DISTINCT");
            List<String> list = resultMapped.getDistinct().getList();
            int size = list.size();
            int i = 0;
            StringBuilder distinctColumn = new StringBuilder();
            distinctColumn.append((CharSequence)columnBuilder);
            for (String resultKey : list) {
                this.addConditonBeforeOptimization(resultKey, sqlBuilder.conditionSet);
                String mapper = this.mapping(resultKey, resultMapped);
                mapperPropertyMap.put(mapper, resultKey);
                distinctColumn.append(" ").append(mapper);
                mapper = this.generate(mapper, resultMapped);
                columnBuilder.append(" ").append(mapper);
                if (++i >= size) continue;
                columnBuilder.append(",");
                distinctColumn.append(",");
            }
            sqlBuilder.countSql = "COUNT(" + distinctColumn.toString() + ") count";
            flag = true;
        }
        if (!(reduceList = resultMapped.getReduceList()).isEmpty()) {
            for (Reduce reduce : reduceList) {
                if (flag) {
                    columnBuilder.append(",");
                }
                this.addConditonBeforeOptimization(reduce.getProperty(), sqlBuilder.conditionSet);
                String alianProperty = reduce.getProperty() + "_" + reduce.getType().toString().toLowerCase();
                String alianName = alianProperty.replace(".", "$");
                resultMapped.getResultKeyAliaMap().put(alianName, alianProperty);
                String value = this.mapping(reduce.getProperty(), criteria);
                ReduceType reduceType = reduce.getType();
                if (reduceType == ReduceType.GROUP_CONCAT_DISTINCT) {
                    reduceType = ReduceType.GROUP_CONCAT;
                    value = "DISTINCT " + value;
                } else if (reduceType == ReduceType.SUM_DISTINCT) {
                    reduceType = ReduceType.SUM;
                    value = "DISTINCT " + value;
                } else if (reduceType == ReduceType.COUNT_DISTINCT) {
                    reduceType = ReduceType.COUNT;
                    value = "DISTINCT " + value;
                } else if (reduceType == ReduceType.AVG_DISTINCT) {
                    reduceType = ReduceType.AVG;
                    value = "DISTINCT " + value;
                }
                columnBuilder.append(" ").append((Object)reduceType).append("(").append(value).append(")").append(" ").append(" AS ").append(" ").append(alianName);
                Having h = reduce.getHaving();
                if (h != null) {
                    h.setAliaOrFunction(alianName);
                    resultMapped.getHavingList().add(h);
                }
                flag = true;
            }
        }
        if (!(resultList = resultMapped.getResultKeyList()).isEmpty()) {
            if (flag) {
                columnBuilder.append(",");
            }
            int size = resultList.size();
            for (int i = 0; i < size; ++i) {
                String resultKey = resultList.get(i);
                this.addConditonBeforeOptimization(resultKey, sqlBuilder.conditionSet);
                String mapper = this.mapping(resultKey, criteria);
                mapperPropertyMap.put(mapper, resultKey);
                mapper = this.generate(mapper, resultMapped);
                columnBuilder.append(" ").append(mapper);
                if (i < size - 1) {
                    columnBuilder.append(",");
                }
                flag = true;
            }
        }
        if (!(resultListAssignedAliaList = resultMapped.getResultKeyAssignedAliaList()).isEmpty()) {
            if (flag) {
                columnBuilder.append(",");
            }
            int size = resultListAssignedAliaList.size();
            for (int i = 0; i < size; ++i) {
                KV kv = resultListAssignedAliaList.get(i);
                String key = kv.getK();
                this.addConditonBeforeOptimization(key, sqlBuilder.conditionSet);
                String mapper = this.mapping(key, criteria);
                mapperPropertyMap.put(mapper, key);
                String alian = kv.getV().toString();
                resultMapped.getResultKeyAliaMap().put(alian, mapper);
                columnBuilder.append(" ").append(mapper).append(" AS ").append(alian);
                if (i < size - 1) {
                    columnBuilder.append(",");
                }
                flag = true;
            }
        }
        if (!(functionList = resultMapped.getResultFunctionList()).isEmpty()) {
            if (flag) {
                columnBuilder.append(",");
            }
            Map<String, String> resultKeyAliaMap = resultMapped.getResultKeyAliaMap();
            int size = functionList.size();
            for (int i = 0; i < size; ++i) {
                FunctionResultKey functionResultKey = functionList.get(i);
                String function = functionResultKey.getScript();
                columnBuilder.append(" ");
                String functionStr = this.normalizeSql(function);
                List<String> originList = this.mapping(reg -> functionStr.split(reg), criteria, columnBuilder);
                for (String origin : originList) {
                    this.addConditonBeforeOptimization(origin, sqlBuilder.conditionSet);
                }
                for (Object obj : functionResultKey.getValues()) {
                    sqlBuildingAttached.getValueList().add(obj);
                }
                String aliaKey = functionResultKey.getAlia();
                String alian = aliaKey.replace(".", "_");
                resultKeyAliaMap.put(aliaKey, alian);
                mapperPropertyMap.put(alian, aliaKey);
                columnBuilder.append(" AS ").append(alian);
                if (i >= size - 1) continue;
                columnBuilder.append(",");
            }
        }
        if (SqliStringUtil.isNullOrEmpty(script = columnBuilder.toString())) {
            throw new CriteriaSyntaxException("Suggest API: find(Criteria criteria), no any resultKey for ResultMapCriteria");
        }
        return script;
    }

    private void select(SqlBuilder sqlBuilder, String resultKeys) {
        sqlBuilder.sbResult.append("SELECT").append(" ").append(resultKeys).append(" ");
    }

    private void groupBy(SqlBuilder sb, Criteria criteria) {
        if (criteria instanceof Criteria.ResultMapCriteria) {
            Criteria.ResultMapCriteria rm = (Criteria.ResultMapCriteria)criteria;
            String groupByS = rm.getGroupBy();
            if (SqliStringUtil.isNullOrEmpty(groupByS)) {
                return;
            }
            sb.sbCondition.append(Op.GROUP_BY.sql());
            String[] arr = groupByS.split(",");
            int i = 0;
            int l = arr.length;
            for (String groupBy : arr) {
                String groupByStr = groupBy.trim();
                if (!SqliStringUtil.isNotNull(groupBy)) continue;
                if (groupBy.contains("(")) {
                    String groupByStrFinal = this.normalizeSql(groupByStr);
                    List<String> originList = this.mapping(reg -> groupByStrFinal.split(reg), criteria, sb.sbCondition);
                    for (String origin : originList) {
                        this.addConditonBeforeOptimization(origin, sb.conditionSet);
                    }
                } else {
                    String mapper = this.mapping(groupByStr, rm);
                    this.addConditonBeforeOptimization(groupByStr, sb.conditionSet);
                    sb.sbCondition.append(mapper);
                }
                if (++i >= l) continue;
                sb.sbCondition.append(",");
            }
        }
    }

    private void having(SqlBuilder sb, Criteria criteria) {
        if (!(criteria instanceof Criteria.ResultMapCriteria)) {
            return;
        }
        Criteria.ResultMapCriteria resultMapped = (Criteria.ResultMapCriteria)criteria;
        List<Having> havingList = resultMapped.getHavingList();
        if (havingList.isEmpty()) {
            return;
        }
        if (!criteria.isTotalRowsIgnored()) {
            throw new CriteriaSyntaxException("Reduce with having not support totalRows query, try to builder.paged().ignoreTotalRows()");
        }
        boolean flag = true;
        for (Having h : havingList) {
            if (h == null) continue;
            if (flag) {
                sb.sbCondition.append(Op.HAVING.sql());
                flag = false;
            } else {
                sb.sbCondition.append(Op.AND.sql());
            }
            String alia = h.getAliaOrFunction();
            if (alia.contains("(")) {
                String finalKey = alia = this.normalizeSql(alia);
                List<String> originList = this.mapping(reg -> finalKey.split(reg), criteria, sb.sbCondition);
                for (String origin : originList) {
                    this.addConditonBeforeOptimization(origin, sb.conditionSet);
                }
            } else {
                sb.sbCondition.append(alia);
                this.addConditonBeforeOptimization(alia, sb.conditionSet);
            }
            sb.sbCondition.append(" ").append(h.getOp().sql()).append(" ").append(h.getValue());
        }
    }

    private void parseAliaFromRefresh(RefreshCondition refreshCondition) {
        String script = refreshCondition.getSourceScript();
        List<String> list = SourceScriptBuilder.split(script);
        List<SourceScript> sourceScripts = SourceScriptBuilder.parse(list);
        SourceScriptBuilder.checkAlia(sourceScripts);
        for (SourceScript sc : sourceScripts) {
            refreshCondition.getAliaMap().put(sc.alia(), sc.getSource());
        }
    }

    private void parseAlia(Criteria criteria, SqlBuilder sqlBuilder) {
        if (criteria instanceof Criteria.ResultMapCriteria) {
            Criteria.ResultMapCriteria rmc = (Criteria.ResultMapCriteria)criteria;
            if (rmc.getSourceScripts().isEmpty()) {
                String sourceScript = rmc.sourceScript();
                List<String> list = SourceScriptBuilder.split(sourceScript);
                List<SourceScript> sourceScripts = SourceScriptBuilder.parse(list);
                rmc.getSourceScripts().addAll(sourceScripts);
            }
            SourceScriptBuilder.checkAlia(rmc.getSourceScripts());
            this.supportSingleSource(rmc);
            Map<String, String> aliaMap = rmc.getAliaMap();
            for (SourceScript sc : rmc.getSourceScripts()) {
                if (!SqliStringUtil.isNotNull(sc.getSource())) continue;
                aliaMap.put(sc.alia(), sc.getSource());
            }
            for (SourceScript sourceScript : rmc.getSourceScripts()) {
                this.addConditionBeforeOptimization(sourceScript.getBbList(), sqlBuilder.conditionSet);
            }
        }
    }

    private void sourceScript(SqlBuilder sb, Criteria criteria) {
        sb.sbSource.append(" ");
        String script = null;
        if (criteria instanceof Criteria.ResultMapCriteria) {
            Criteria.ResultMapCriteria rmc = (Criteria.ResultMapCriteria)criteria;
            if (rmc.getSourceScripts().isEmpty()) {
                String str = criteria.sourceScript();
                Objects.requireNonNull(str, "Not set sourceScript of ResultMappedBuilder");
                String strd = this.normalizeSql(str);
                StringBuilder sbs = new StringBuilder();
                this.mapping(reg -> strd.split(reg), rmc, sbs);
                script = sbs.toString();
            } else {
                if (!rmc.isWithoutOptimization()) {
                    this.optimizeSourceScript(sb.conditionSet, rmc.getSourceScripts());
                }
                script = rmc.getSourceScripts().stream().map(sourceScript -> sourceScript.sql(rmc)).collect(Collectors.joining()).trim();
            }
            sb.sbSource.append("FROM").append(" ");
        } else {
            script = this.mapping(criteria.sourceScript(), criteria);
            if (!script.startsWith("FROM") || !script.startsWith("FROM".toLowerCase())) {
                sb.sbSource.append("FROM").append(" ");
            }
        }
        sb.sbSource.append(script);
    }

    private void forceIndex(boolean isSub, SqlBuilder sqlBuilder, Criteria criteria) {
        if (isSub) {
            return;
        }
        if (SqliStringUtil.isNullOrEmpty(criteria.getForceIndex())) {
            return;
        }
        sqlBuilder.sbCondition.append(" FORCE INDEX(" + criteria.getForceIndex() + ")");
        this.addConditonBeforeOptimization(criteria.getForceIndex(), sqlBuilder.conditionSet);
    }

    private void count(boolean isSub, boolean isTotalRowsIgnored, SqlBuilder sqlBuilder) {
        if (isSub || isTotalRowsIgnored) {
            return;
        }
        sqlBuilder.countCondition = new StringBuilder();
        sqlBuilder.countCondition.append((CharSequence)sqlBuilder.sbCondition);
    }

    private void sort(SqlBuilder sb, Criteria criteria) {
        if (criteria.isFixedSort()) {
            return;
        }
        List<Sort> sortList = criteria.getSortList();
        if (sortList != null && !sortList.isEmpty()) {
            sb.sbCondition.append(Op.ORDER_BY.sql());
            int size = sortList.size();
            int i = 0;
            for (Sort sort : sortList) {
                String orderBy = sort.getOrderBy();
                String mapper = this.mapping(orderBy, criteria);
                sb.sbCondition.append(mapper).append(" ");
                this.addConditonBeforeOptimization(orderBy, sb.conditionSet);
                Direction direction = sort.getDirection();
                if (direction == null) {
                    sb.sbCondition.append((Object)Direction.DESC);
                } else {
                    sb.sbCondition.append((Object)direction);
                }
                if (++i >= size) continue;
                sb.sbCondition.append(",").append(" ");
            }
        }
    }

    private void filter0(Criteria criteria) {
        List<Bb> bbList = criteria.getBbList();
        if (criteria instanceof Criteria.ResultMapCriteria) {
            Criteria.ResultMapCriteria resultMapCriteria = (Criteria.ResultMapCriteria)criteria;
            this.filter(bbList, resultMapCriteria);
            for (SourceScript sourceScript : ((Criteria.ResultMapCriteria)criteria).getSourceScripts()) {
                List<Bb> bbs = sourceScript.getBbList();
                if (bbs == null || bbs.isEmpty()) continue;
                this.filter(bbs, resultMapCriteria);
            }
        } else {
            this.filter(bbList, criteria);
        }
    }

    private void sourceScriptPre(Criteria criteria, SqlBuildingAttached attached) {
        if (criteria instanceof Criteria.ResultMapCriteria) {
            for (SourceScript sourceScript : ((Criteria.ResultMapCriteria)criteria).getSourceScripts()) {
                sourceScript.pre(attached, this);
            }
        }
    }

    private void condition(SqlBuilder sqlBuilder, List<Bb> bbList, Criteria criteria, List<Object> valueList) {
        if (bbList.isEmpty()) {
            return;
        }
        this.addConditionBeforeOptimization(bbList, sqlBuilder.conditionSet);
        StringBuilder xsb = new StringBuilder();
        this.pre(valueList, bbList);
        if (bbList.isEmpty()) {
            return;
        }
        bbList.get(0).setC(Op.WHERE);
        this.buildConditionSql(xsb, bbList, criteria);
        sqlBuilder.sbCondition.append((CharSequence)xsb);
    }

    public static final class SqlBuilder {
        private StringBuilder sbResult = new StringBuilder();
        private StringBuilder sbSource = new StringBuilder();
        private StringBuilder sbCondition = new StringBuilder();
        private Set<String> conditionSet = new HashSet<String>();
        private String countSql = "COUNT(*) count";
        private StringBuilder countCondition;

        public static SqlBuilder get() {
            return new SqlBuilder();
        }
    }
}

