/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.builder;

import io.xream.sqli.builder.Bb;
import io.xream.sqli.builder.On;
import io.xream.sqli.builder.SourceScript;
import io.xream.sqli.util.SqliStringUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public interface SourceScriptOptimizable {
    default public void addConditonBeforeOptimization(String key, Set<String> conditionSet) {
        conditionSet.add(key);
    }

    default public void addConditionBeforeOptimization(List<Bb> bbList, Set<String> conditionSet) {
        if (bbList == null) {
            return;
        }
        for (Bb bb : bbList) {
            conditionSet.add(bb.getKey());
            List<Bb> subList = bb.getSubList();
            if (subList == null || subList.isEmpty()) continue;
            this.addConditionBeforeOptimization(subList, conditionSet);
        }
    }

    default public void optimizeSourceScript(Set<String> conditionSet, List<SourceScript> sourceScripts) {
        SourceScript sourceScript;
        if (sourceScripts.size() <= 1) {
            return;
        }
        if (conditionSet.size() > 0) {
            for (String test : conditionSet) {
                if (test == null) continue;
                if (test.contains(".")) break;
                return;
            }
        }
        block1: for (SourceScript sourceScript2 : sourceScripts) {
            if (sourceScript2.getSubCriteria() != null) {
                sourceScript2.used();
                continue;
            }
            for (String key : conditionSet) {
                if (key == null) continue;
                if (SqliStringUtil.isNullOrEmpty(sourceScript2.getAlia())) {
                    if (!key.contains(sourceScript2.getSource() + ".")) continue;
                    sourceScript2.used();
                    continue block1;
                }
                if (!key.contains(sourceScript2.getAlia() + ".")) continue;
                sourceScript2.used();
                continue block1;
            }
        }
        int size = sourceScripts.size();
        block3: for (int i = size - 1; i >= 0; --i) {
            sourceScript = sourceScripts.get(i);
            if (sourceScript.getSubCriteria() != null) {
                sourceScript.targeted();
                continue;
            }
            if (!sourceScript.isUsed() && !sourceScript.isTargeted()) continue;
            for (int j = i - 1; j >= 0; --j) {
                On on;
                SourceScript sc = sourceScripts.get(j);
                if (sourceScript.getSource().equals(sc.getSource()) || (on = sourceScript.getOn()) == null || on.getJoinFrom() == null || !sc.alia().equals(on.getJoinFrom().getAlia())) continue;
                sc.targeted();
                continue block3;
            }
        }
        Iterator<SourceScript> ite = sourceScripts.iterator();
        while (ite.hasNext()) {
            sourceScript = ite.next();
            if (sourceScript.isUsed() || sourceScript.isTargeted()) continue;
            ite.remove();
        }
    }
}

