/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.builder;

import io.xream.sqli.builder.Bb;
import io.xream.sqli.builder.ConditionCriteriaBuilder;
import io.xream.sqli.builder.Criteria;
import io.xream.sqli.builder.Direction;
import io.xream.sqli.builder.Distinct;
import io.xream.sqli.builder.FunctionResultKey;
import io.xream.sqli.builder.Having;
import io.xream.sqli.builder.JoinFrom;
import io.xream.sqli.builder.JoinType;
import io.xream.sqli.builder.KV;
import io.xream.sqli.builder.On;
import io.xream.sqli.builder.Op;
import io.xream.sqli.builder.PageBuilder;
import io.xream.sqli.builder.Reduce;
import io.xream.sqli.builder.ReduceType;
import io.xream.sqli.builder.ResultKeyAlia;
import io.xream.sqli.builder.Sort;
import io.xream.sqli.builder.SourceScript;
import io.xream.sqli.builder.SourceScriptBuilder;
import io.xream.sqli.builder.Sub;
import io.xream.sqli.page.Paged;
import io.xream.sqli.parser.Parsed;
import io.xream.sqli.parser.Parser;
import io.xream.sqli.util.SqliStringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CriteriaBuilder
extends ConditionCriteriaBuilder {
    private Criteria criteria;
    private PageBuilder pageBuilder;
    protected SourceScript sourceScriptTemp;

    public CriteriaBuilder routeKey(Object routeKey) {
        this.criteria.setRouteKey(routeKey);
        return this;
    }

    public PageBuilder paged() {
        if (this.pageBuilder != null) {
            return this.pageBuilder;
        }
        this.pageBuilder = new PageBuilder(){

            @Override
            public PageBuilder ignoreTotalRows() {
                CriteriaBuilder.this.criteria.setTotalRowsIgnored(true);
                return this;
            }

            @Override
            public PageBuilder rows(int rows) {
                CriteriaBuilder.this.criteria.setRows(rows);
                return this;
            }

            @Override
            public PageBuilder page(int page) {
                CriteriaBuilder.this.criteria.setPage(page);
                return this;
            }
        };
        return this.pageBuilder;
    }

    public void paged(Paged paged) {
        this.criteria.paged(paged);
    }

    public CriteriaBuilder sortIn(String porperty, List<? extends Object> inList) {
        if (Objects.nonNull(inList) && inList.size() > 0) {
            KV kv = new KV(porperty, inList);
            List<KV> fixedSortList = this.criteria.getFixedSortList();
            if (fixedSortList == null) {
                fixedSortList = new ArrayList<KV>();
                this.criteria.setFixedSortList(fixedSortList);
            }
            fixedSortList.add(kv);
        }
        return this;
    }

    public CriteriaBuilder sort(String orderBy, Direction direction) {
        if (SqliStringUtil.isNullOrEmpty(orderBy)) {
            return this;
        }
        List<Sort> sortList = this.criteria.getSortList();
        if (sortList == null) {
            sortList = new ArrayList<Sort>();
            this.criteria.setSortList(sortList);
        }
        Sort sort = new Sort(orderBy, direction);
        sortList.add(sort);
        return this;
    }

    public CriteriaBuilder forceIndex(String indexName) {
        if (SqliStringUtil.isNullOrEmpty(indexName)) {
            return this;
        }
        this.criteria.setForceIndex(indexName);
        return this;
    }

    private CriteriaBuilder(Criteria criteria) {
        super(criteria.getBbList());
        this.criteria = criteria;
    }

    public static CriteriaBuilder builder(Class<?> clz) {
        Criteria criteria = new Criteria();
        criteria.setClzz(clz);
        CriteriaBuilder builder = new CriteriaBuilder(criteria);
        if (criteria.getParsed() == null) {
            Parsed parsed = Parser.get(clz);
            criteria.setParsed(parsed);
        }
        return builder;
    }

    public static ResultMapBuilder resultMapBuilder() {
        Criteria.ResultMapCriteria resultMapCriteria = new Criteria.ResultMapCriteria();
        return new ResultMapBuilder(resultMapCriteria);
    }

    public Class<?> getClz() {
        return this.criteria.getClzz();
    }

    protected Criteria get() {
        return this.criteria;
    }

    public Criteria build() {
        return this.criteria;
    }

    public void clear() {
        this.criteria = null;
    }

    public static final class ResultMapBuilder
    extends CriteriaBuilder {
        private SourceScriptBuilder sourceScriptBuilder = new SourceScriptBuilder(){

            @Override
            public SourceScriptBuilder source(String source) {
                sourceScriptTemp.setSource(source);
                return this;
            }

            @Override
            public SourceScriptBuilder sub(Sub sub) {
                ResultMapBuilder subBuilder = CriteriaBuilder.resultMapBuilder();
                sub.buildBy(subBuilder);
                Criteria.ResultMapCriteria resultMapCriteria = subBuilder.build();
                sourceScriptTemp.setSubCriteria(resultMapCriteria);
                subBuilder.clear();
                return this;
            }

            @Override
            public SourceScriptBuilder alia(String alia) {
                sourceScriptTemp.setAlia(alia);
                return this;
            }

            @Override
            public SourceScriptBuilder join(JoinType joinType) {
                sourceScriptTemp.setJoinType(joinType);
                return this;
            }

            @Override
            public SourceScriptBuilder join(String joinStr) {
                sourceScriptTemp.setJoinStr(joinStr);
                return this;
            }

            @Override
            public SourceScriptBuilder on(String key, JoinFrom joinFrom) {
                if (key.contains(".")) {
                    throw new IllegalArgumentException("On key can not contains '.'");
                }
                On on = new On();
                on.setKey(key);
                on.setOp(Op.EQ.sql());
                on.setJoinFrom(joinFrom);
                sourceScriptTemp.setOn(on);
                return this;
            }

            @Override
            public SourceScriptBuilder on(String key, Op op, JoinFrom joinFrom) {
                if (key.contains(".")) {
                    throw new IllegalArgumentException("On key can not contains '.'");
                }
                On on = new On();
                on.setKey(key);
                on.setOp(op.sql());
                on.setJoinFrom(joinFrom);
                sourceScriptTemp.setOn(on);
                return this;
            }

            @Override
            public ConditionCriteriaBuilder more() {
                ArrayList<Bb> bbList = new ArrayList<Bb>();
                sourceScriptTemp.setBbList(bbList);
                return ConditionCriteriaBuilder.build(bbList);
            }
        };

        public SourceScriptBuilder sourceBuilder() {
            this.sourceScriptTemp = new SourceScript();
            this.get().getSourceScripts().add(this.sourceScriptTemp);
            return this.sourceScriptBuilder;
        }

        public ResultMapBuilder withoutOptimization() {
            this.get().setWithoutOptimization(true);
            return this;
        }

        @Override
        protected Criteria.ResultMapCriteria get() {
            return (Criteria.ResultMapCriteria)super.get();
        }

        @Override
        public Criteria.ResultMapCriteria build() {
            return (Criteria.ResultMapCriteria)super.get();
        }

        public ResultMapBuilder(Criteria criteria) {
            super(criteria);
        }

        public ResultMapBuilder resultKey(String resultKey) {
            if (SqliStringUtil.isNullOrEmpty(resultKey)) {
                return this;
            }
            this.get().getResultKeyList().add(resultKey);
            return this;
        }

        public ResultMapBuilder resultKey(String resultKey, String alia) {
            if (SqliStringUtil.isNullOrEmpty(resultKey)) {
                return this;
            }
            Objects.requireNonNull(alia, "resultKeyAssignedAlia(), alia can not null");
            this.get().getResultKeyAssignedAliaList().add(new KV(resultKey, alia));
            return this;
        }

        public ResultMapBuilder resultWithDottedKey() {
            this.get().setResultWithDottedKey(true);
            return this;
        }

        public ResultMapBuilder resultKeyFunction(ResultKeyAlia functionAlia_wrap, String functionScript, String ... values) {
            if (SqliStringUtil.isNullOrEmpty(functionScript) || values == null) {
                return this;
            }
            Objects.requireNonNull(functionAlia_wrap, "function no alia");
            Objects.requireNonNull(functionAlia_wrap.getAlia());
            FunctionResultKey functionResultKey = new FunctionResultKey();
            functionResultKey.setScript(functionScript);
            functionResultKey.setAlia(functionAlia_wrap.getAlia());
            functionResultKey.setValues(values);
            this.get().getResultFunctionList().add(functionResultKey);
            return this;
        }

        public ResultMapBuilder sourceScript(String sourceScript) {
            if (SqliStringUtil.isNullOrEmpty(sourceScript)) {
                return this;
            }
            this.get().setSourceScript(sourceScript);
            return this;
        }

        public ResultMapBuilder distinct(String ... objs) {
            if (objs == null) {
                throw new IllegalArgumentException("distinct non resultKey");
            }
            Criteria.ResultMapCriteria resultMapped = this.get();
            Distinct distinct = resultMapped.getDistinct();
            if (Objects.isNull(distinct)) {
                distinct = new Distinct();
                resultMapped.setDistinct(distinct);
            }
            for (String obj : objs) {
                distinct.add(obj);
            }
            return this;
        }

        public ResultMapBuilder groupBy(String property) {
            this.get().setGroupBy(property);
            return this;
        }

        public ResultMapBuilder having(ResultKeyAlia resultKeyAlia, Op op, Object value) {
            Having having = Having.of(op, value);
            having.setAliaOrFunction(resultKeyAlia.getKey());
            this.get().getHavingList().add(having);
            return this;
        }

        public ResultMapBuilder having(String functionScript, Op op, Object value) {
            Having having = Having.of(op, value);
            having.setAliaOrFunction(functionScript);
            this.get().getHavingList().add(having);
            return this;
        }

        public ResultMapBuilder reduce(ReduceType type, String property) {
            Reduce reduce = new Reduce();
            reduce.setType(type);
            reduce.setProperty(property);
            this.get().getReduceList().add(reduce);
            return this;
        }

        @Override
        public ResultMapBuilder sort(String orderBy, Direction direction) {
            return (ResultMapBuilder)super.sort(orderBy, direction);
        }

        public ResultMapBuilder reduce(ReduceType type, String property, Having having) {
            Reduce reduce = new Reduce();
            reduce.setType(type);
            reduce.setProperty(property);
            reduce.setHaving(having);
            this.get().getReduceList().add(reduce);
            return this;
        }

        @Override
        public ResultMapBuilder eq(String key, Object value) {
            return (ResultMapBuilder)super.eq(key, value);
        }

        @Override
        public ResultMapBuilder gt(String key, Object value) {
            return (ResultMapBuilder)super.gt(key, value);
        }

        @Override
        public ResultMapBuilder gte(String key, Object value) {
            return (ResultMapBuilder)super.gte(key, value);
        }

        @Override
        public ResultMapBuilder lt(String key, Object value) {
            return (ResultMapBuilder)super.lt(key, value);
        }

        @Override
        public ResultMapBuilder lte(String key, Object value) {
            return (ResultMapBuilder)super.lte(key, value);
        }

        @Override
        public ResultMapBuilder ne(String property, Object value) {
            return (ResultMapBuilder)super.ne(property, value);
        }

        @Override
        public ResultMapBuilder like(String property, String value) {
            return (ResultMapBuilder)super.like(property, value);
        }

        @Override
        public ResultMapBuilder likeRight(String property, String value) {
            return (ResultMapBuilder)super.likeRight(property, value);
        }

        @Override
        public ResultMapBuilder notLike(String property, String value) {
            return (ResultMapBuilder)super.notLike(property, value);
        }

        @Override
        public ResultMapBuilder in(String property, List<? extends Object> list) {
            return (ResultMapBuilder)super.in(property, list);
        }

        @Override
        public ResultMapBuilder nin(String property, List<? extends Object> list) {
            return (ResultMapBuilder)super.nin(property, list);
        }

        @Override
        public ResultMapBuilder nonNull(String property) {
            return (ResultMapBuilder)super.nonNull(property);
        }

        @Override
        public ResultMapBuilder isNull(String property) {
            return (ResultMapBuilder)super.isNull(property);
        }

        public ResultMapBuilder x(String sqlSegment) {
            return (ResultMapBuilder)super.x(sqlSegment, new Object[0]);
        }

        @Override
        public ResultMapBuilder x(String sqlSegment, Object ... valueList) {
            return (ResultMapBuilder)super.x(sqlSegment, valueList);
        }

        @Override
        public ResultMapBuilder beginSub() {
            return (ResultMapBuilder)super.beginSub();
        }

        @Override
        public ResultMapBuilder endSub() {
            return (ResultMapBuilder)super.endSub();
        }

        @Override
        public void clear() {
            super.clear();
        }
    }
}

