/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.util;

import io.xream.sqli.util.SqliStringUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public final class SqliLoggerProxy {
    private static final Map<Class, Logger> loggerMap = new HashMap<Class, Logger>();

    private SqliLoggerProxy() {
    }

    public static void put(Class clzz, Logger logger) {
        loggerMap.put(clzz, logger);
    }

    public static void debug(Class clzz, Object obj) {
        Logger logger = loggerMap.get(clzz);
        if (logger == null || obj == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(obj.toString());
        }
    }

    public static void debug(Class clzz, LogCallable callable) {
        Logger logger = loggerMap.get(clzz);
        if (logger == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            if (callable == null) {
                return;
            }
            String str = callable.call();
            if (SqliStringUtil.isNullOrEmpty(str)) {
                return;
            }
            logger.debug(str);
        }
    }

    public static void info(Class clzz, Object obj) {
        Logger logger = loggerMap.get(clzz);
        if (logger == null || obj == null) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info(obj.toString());
        }
    }

    public static long getTimeMills(Class clzz) {
        Logger logger = loggerMap.get(clzz);
        if (logger == null) {
            return 0L;
        }
        if (logger.isDebugEnabled()) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    public static interface LogCallable {
        public String call();
    }
}

