/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.util;

import io.xream.sqli.annotation.X;
import io.xream.sqli.builder.SqlScript;
import io.xream.sqli.parser.BeanElement;
import io.xream.sqli.parser.Parsed;
import io.xream.sqli.parser.Parser;
import io.xream.sqli.util.BeanUtil;
import io.xream.sqli.util.SqliStringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ParserUtil {
    public static final String SQL_KEYWORD_MARK = "`";

    private ParserUtil() {
    }

    private static void parseFieldsOfElementList(Class clz, Map<String, Field> filterMap, Map<String, Field> allMap) {
        ArrayList<Field> fl = new ArrayList<Field>();
        if (clz.getSuperclass() != Object.class) {
            fl.addAll(Arrays.asList(clz.getSuperclass().getDeclaredFields()));
        }
        fl.addAll(Arrays.asList(clz.getDeclaredFields()));
        for (Field f : fl) {
            X.Ignore p;
            allMap.put(f.getName(), f);
            if (f.getModifiers() >= 128) {
                filterMap.put(f.getName(), f);
            }
            if ((p = f.getAnnotation(X.Ignore.class)) == null) continue;
            filterMap.put(f.getName(), f);
        }
    }

    private static void parseMethodsOfElementList(Class clz, Set<String> mns, List<Method> methodList) {
        if (clz.getSuperclass() != Object.class) {
            methodList.addAll(Arrays.asList(clz.getSuperclass().getDeclaredMethods()));
        }
        methodList.addAll(Arrays.asList(clz.getDeclaredMethods()));
        for (Method m : methodList) {
            mns.add(m.getName());
        }
    }

    private static void parseFilterListOfElementList(List<BeanElement> filterList, Set<String> mns, List<Method> ml) {
        for (Method m : ml) {
            String name = m.getName();
            if (!name.startsWith("set") && !name.startsWith("get") && !name.startsWith("is")) continue;
            String key = BeanUtil.getProperty(name);
            BeanElement be = null;
            for (BeanElement b : filterList) {
                if (!b.getProperty().equals(key)) continue;
                be = b;
                break;
            }
            if (be == null) {
                be = new BeanElement();
                be.setProperty(key);
                filterList.add(be);
            }
            if (name.startsWith("set")) {
                be.setSetter(name);
                continue;
            }
            if (name.startsWith("get")) {
                be.setGetter(name);
                be.setClz(m.getReturnType());
                continue;
            }
            if (!name.startsWith("is")) continue;
            be.setGetter(name);
            be.setClz(m.getReturnType());
            be.setProperty(name);
            String setter = BeanUtil.getSetter(name);
            if (!mns.contains(setter)) continue;
            be.setSetter(setter);
        }
    }

    private static void filterElementList(List<BeanElement> filterList, Map<String, Field> filterMap) {
        Iterator<BeanElement> ite = filterList.iterator();
        while (ite.hasNext()) {
            BeanElement be = ite.next();
            if (be.isPair()) continue;
            ite.remove();
        }
        block1: for (String key : filterMap.keySet()) {
            Iterator<BeanElement> beIte = filterList.iterator();
            while (beIte.hasNext()) {
                BeanElement be = beIte.next();
                if (!be.getProperty().equals(key)) continue;
                beIte.remove();
                continue block1;
            }
        }
    }

    private static List<BeanElement> buildElementList(Class clz, List<BeanElement> filterList, Map<String, Field> allMap) {
        ArrayList<BeanElement> list = new ArrayList<BeanElement>();
        for (BeanElement element : filterList) {
            ParserUtil.parseAnno(clz, element, allMap.get(element.getProperty()));
            Class ec = element.getClz();
            if (element.getSqlType() == null) {
                if (ec == Integer.TYPE || ec == Integer.class) {
                    element.setSqlType("int");
                    element.setLength(11);
                } else if (ec == Long.TYPE || ec == Long.class) {
                    element.setSqlType("bigint");
                    element.setLength(13);
                } else if (ec == Double.TYPE || ec == Double.class) {
                    element.setSqlType("float");
                    element.setLength(13);
                } else if (ec == Float.TYPE || ec == Float.class) {
                    element.setSqlType("float");
                    element.setLength(13);
                } else if (ec == Boolean.TYPE || ec == Boolean.class) {
                    element.setSqlType("tinyint");
                    element.setLength(1);
                } else if (ec == java.util.Date.class || ec == Date.class || ec == Timestamp.class) {
                    element.setSqlType("timestamp");
                } else if (ec == String.class) {
                    element.setSqlType("varchar");
                    if (element.getLength() == 0) {
                        element.setLength(60);
                    }
                } else if (ec == BigDecimal.class) {
                    element.setSqlType("decimal");
                } else if (BeanUtil.isEnum(ec)) {
                    element.setSqlType("varchar");
                    if (element.getLength() == 0) {
                        element.setLength(20);
                    }
                } else {
                    element.setJson(true);
                    if (ec == List.class) {
                        Field field = null;
                        try {
                            field = clz.getDeclaredField(element.getProperty());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ParameterizedType pt = (ParameterizedType)field.getGenericType();
                        Class geneType = (Class)pt.getActualTypeArguments()[0];
                        element.setGeneType(geneType);
                    }
                    element.setSqlType("varchar");
                    if (element.getLength() == 0) {
                        element.setLength(512);
                    }
                }
            } else if (element.getSqlType().contains("text")) {
                element.setLength(0);
            } else {
                element.setSqlType("varchar");
            }
            list.add(element);
        }
        return list;
    }

    private static void initMethodCache(Class clz, List<BeanElement> list) {
        try {
            for (BeanElement be : list) {
                try {
                    be.setSetMethod(clz.getDeclaredMethod(be.getSetter(), be.getClz()));
                }
                catch (NoSuchMethodException e) {
                    be.setSetMethod(clz.getSuperclass().getDeclaredMethod(be.getSetter(), be.getClz()));
                }
                try {
                    be.setGetMethod(clz.getDeclaredMethod(be.getGetter(), new Class[0]));
                }
                catch (NoSuchMethodException e) {
                    be.setGetMethod(clz.getSuperclass().getDeclaredMethod(be.getGetter(), new Class[0]));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<BeanElement> parseElementList(Class clz) {
        HashMap<String, Field> filterMap = new HashMap<String, Field>();
        HashMap<String, Field> allMap = new HashMap<String, Field>();
        ParserUtil.parseFieldsOfElementList(clz, filterMap, allMap);
        HashSet<String> mns = new HashSet<String>();
        ArrayList<Method> ml = new ArrayList<Method>();
        ParserUtil.parseMethodsOfElementList(clz, mns, ml);
        ArrayList<BeanElement> filterList = new ArrayList<BeanElement>();
        ParserUtil.parseFilterListOfElementList(filterList, mns, ml);
        ParserUtil.filterElementList(filterList, filterMap);
        List<BeanElement> list = ParserUtil.buildElementList(clz, filterList, allMap);
        ParserUtil.initMethodCache(clz, list);
        return list;
    }

    public static void parseCacheableAnno(Class clz, Parsed parsed) {
        X.NoCache p = clz.getAnnotation(X.NoCache.class);
        if (p != null) {
            parsed.setNoCache(true);
        }
    }

    private static void parseAnno(Class clz, BeanElement ele, Field f) {
        X p;
        Method m = null;
        try {
            m = clz.getDeclaredMethod(ele.getGetter(), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (m != null && (p = m.getAnnotation(X.class)) != null) {
            ele.setLength(p.length());
        }
        if (f != null) {
            X.Mapping mapping;
            p = f.getAnnotation(X.class);
            if (p != null) {
                ele.setLength(p.length());
            }
            if ((mapping = f.getAnnotation(X.Mapping.class)) != null && SqliStringUtil.isNotNull(mapping.value())) {
                ele.setMapper(mapping.value());
            }
        }
    }

    public static void parseKey(Parsed parsed, Class clz) {
        Map<Integer, String> map = parsed.getKeyMap();
        Map<Integer, Field> keyFieldMap = parsed.getKeyFieldMap();
        ArrayList<Field> list = new ArrayList<Field>();
        try {
            list.addAll(Arrays.asList(clz.getDeclaredFields()));
            Class sc = clz.getSuperclass();
            if (sc != Object.class) {
                list.addAll(Arrays.asList(sc.getDeclaredFields()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Field f : list) {
            X.Key a = f.getAnnotation(X.Key.class);
            if (a == null) continue;
            map.put(1, f.getName());
            f.setAccessible(true);
            keyFieldMap.put(1, f);
        }
    }

    public static String filterSQLKeyword(String mapper) {
        for (String keyWord : SqlScript.KEYWORDS) {
            if (!keyWord.equalsIgnoreCase(mapper)) continue;
            return SQL_KEYWORD_MARK + mapper + SQL_KEYWORD_MARK;
        }
        return mapper;
    }

    public static String getClzName(String alia, Map<String, String> aliaMap) {
        String a = aliaMap.get(alia);
        if (SqliStringUtil.isNotNull(a)) {
            return a;
        }
        return alia;
    }

    public static <T> Object tryToGetId(T t, Parsed parsed) {
        Field f = parsed.getKeyField(1);
        Object id = null;
        try {
            id = f.get(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id == null) {
            throw new IllegalArgumentException("obj keyOne = " + id + ", " + t);
        }
        return id;
    }

    public static String getCacheKey(Object obj, Parsed parsed) {
        try {
            Object keyOneObj = ParserUtil.tryToGetId(obj, parsed);
            if (keyOneObj != null) {
                return keyOneObj.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getMapper(String property) {
        String AZ = "AZ";
        int min = AZ.charAt(0) - '\u0001';
        int max = AZ.charAt(1) + '\u0001';
        try {
            String spec = Parser.mappingSpec;
            if (SqliStringUtil.isNotNull(spec)) {
                String s;
                char[] arr = property.toCharArray();
                int length = arr.length;
                ArrayList<String> list = new ArrayList<String>();
                StringBuilder temp = new StringBuilder();
                for (int i = 0; i < length; ++i) {
                    char c = arr[i];
                    if (c > min && c < max) {
                        String ts = temp.toString();
                        if (SqliStringUtil.isNotNull(ts)) {
                            list.add(temp.toString());
                        }
                        temp = new StringBuilder();
                        s = String.valueOf(c);
                        temp.append(s.toLowerCase());
                    } else {
                        temp = temp.append(c);
                    }
                    if (i != length - 1) continue;
                    list.add(temp.toString());
                }
                String str = "";
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    s = (String)list.get(i);
                    str = str + s;
                    if (i >= size - 1) continue;
                    str = str + "_";
                }
                return str;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return property;
    }

    public static interface SqlFieldType {
        public static final String TEXT = "text";
        public static final String VARCHAR = "varchar";
        public static final String DATE = "timestamp";
        public static final String INT = "int";
        public static final String LONG = "bigint";
        public static final String BYTE = "tinyint";
        public static final String DOUBLE = "float";
        public static final String FLOAT = "float";
        public static final String DECIMAL = "decimal";
    }
}

