/*
 * Decompiled with CFR 0.152.
 */
package io.xream.sqli.builder;

import io.xream.sqli.builder.Bb;
import io.xream.sqli.builder.Criteria;
import io.xream.sqli.builder.Op;
import io.xream.sqli.filter.BaseTypeFilter;
import io.xream.sqli.mapping.Mappable;
import io.xream.sqli.mapping.Mapper;
import io.xream.sqli.mapping.SqlNormalizer;
import io.xream.sqli.parser.BeanElement;
import io.xream.sqli.parser.Parsed;
import io.xream.sqli.parser.Parser;
import io.xream.sqli.support.TimestampSupport;
import io.xream.sqli.util.BeanUtil;
import io.xream.sqli.util.SqliStringUtil;
import java.util.Iterator;
import java.util.List;

public interface ConditionToSql
extends Mapper,
SqlNormalizer {
    default public void buildConditionSql(StringBuilder sb, List<Bb> bbList, Mappable mappable) {
        if (bbList == null || bbList.isEmpty()) {
            return;
        }
        for (Bb bb : bbList) {
            if (bb.getP() == Op.SUB) {
                if (bb.getSubList().isEmpty()) continue;
                bb.getSubList().get(0).setC(Op.NONE);
                sb.append(bb.getC().sql());
                sb.append(" ").append("(").append(" ");
                this.buildConditionSql(sb, bb.getSubList(), mappable);
                sb.append(" ").append(")");
                continue;
            }
            String mapper = null;
            if (bb.getP() == Op.X) {
                String str = this.normalizeSql(bb.getKey());
                StringBuilder sbx = new StringBuilder();
                this.mapping(reg -> str.split(reg), mappable, sbx);
                mapper = sbx.toString();
                sb.append(bb.getC().sql()).append(mapper);
            } else {
                mapper = this.mapping(bb.getKey(), mappable);
                sb.append(bb.getC().sql()).append(mapper).append(" ").append(bb.getP().sql()).append(" ");
            }
            if (bb.getValue() == null) continue;
            if (bb.getP() == Op.IN || bb.getP() == Op.NOT_IN) {
                List inList = (List)bb.getValue();
                Object v = inList.get(0);
                Class<?> vType = v.getClass();
                ConditionToSql.buildIn(sb, vType, inList);
                continue;
            }
            if (bb.getP() == Op.IS_NULL || bb.getP() == Op.IS_NOT_NULL || bb.getP() == Op.X) continue;
            sb.append("?").append(" ");
        }
    }

    public static void buildIn(StringBuilder sb, Class clz, List<? extends Object> inList) {
        sb.append("(").append(" ");
        int length = inList.size();
        if (clz == String.class) {
            for (int j = 0; j < length; ++j) {
                Object value = inList.get(j);
                if (value == null || SqliStringUtil.isNullOrEmpty(value.toString())) continue;
                value = ConditionToSql.filter(value.toString());
                sb.append("'").append(value).append("'");
                if (j >= length - 1) continue;
                sb.append(",");
            }
        } else if (BeanUtil.isEnum(clz)) {
            for (int j = 0; j < length; ++j) {
                Object value = inList.get(j);
                if (value == null) continue;
                String ev = null;
                ev = value instanceof String ? (String)value : ((Enum)value).name();
                sb.append("'").append(ev).append("'");
                if (j >= length - 1) continue;
                sb.append(",");
            }
        } else {
            for (int j = 0; j < length; ++j) {
                Object value = inList.get(j);
                if (value == null) continue;
                sb.append(value);
                if (j >= length - 1) continue;
                sb.append(",");
            }
        }
        sb.append(" ").append(")");
    }

    public static String filter(String sql) {
        sql = sql.replace("drop", " ").replace(";", " ");
        return sql;
    }

    public static interface Pre {
        default public void pre(List<Object> valueList, List<Bb> bbList) {
            for (Bb bb : bbList) {
                if (bb.getP() == Op.SUB) {
                    this.pre(valueList, bb.getSubList());
                    continue;
                }
                if (bb.getP() == Op.X) {
                    Object value = bb.getValue();
                    if (value == null || !(value instanceof Object[])) continue;
                    for (Object v : (Object[])value) {
                        Pre.add(valueList, v);
                    }
                    continue;
                }
                if (bb.getP() == Op.IN || bb.getP() == Op.NOT_IN || bb.getP() == Op.IS_NULL || bb.getP() == Op.IS_NOT_NULL) continue;
                Object v = bb.getValue();
                Pre.add(valueList, v);
            }
        }

        public static void add(List<Object> valueList, Object value) {
            if (BeanUtil.isEnum(value.getClass())) {
                try {
                    valueList.add(((Enum)value).name());
                }
                catch (Exception exception) {}
            } else {
                valueList.add(value);
            }
        }
    }

    public static interface Filter {
        default public void filter(List<Bb> bbList, Mappable mappable) {
            if (bbList == null || bbList.isEmpty()) {
                return;
            }
            Iterator<Bb> ite = bbList.iterator();
            while (ite.hasNext()) {
                List<Bb> subList;
                Bb bb = ite.next();
                Op p = bb.getP();
                String key = bb.getKey();
                if (p == Op.SUB) {
                    this.filter(bb.getSubList(), mappable);
                    if (bb.getSubList().isEmpty()) {
                        ite.remove();
                    }
                } else if (p == Op.EQ || p == Op.NE || p == Op.GT || p == Op.GTE || p == Op.LT || p == Op.LTE) {
                    if (key.contains(".")) {
                        Parsed parsed;
                        String[] arr = key.split("\\.");
                        String alia = arr[0];
                        String clzName = mappable.getAliaMap().get(alia);
                        if (clzName == null) {
                            clzName = alia;
                        }
                        if ((parsed = Parser.get(clzName)) != null) {
                            if (BaseTypeFilter.isBaseType(arr[1], bb.getValue(), parsed)) {
                                ite.remove();
                            } else {
                                BeanElement be = parsed.getElement(arr[1]);
                                if (be != null) {
                                    TimestampSupport.testNumberValueToDate(be.getClz(), bb);
                                    if (bb.getValue() == null) {
                                        ite.remove();
                                    }
                                }
                            }
                        }
                    } else {
                        String ss;
                        Parsed parsed = mappable.getParsed();
                        if (parsed == null && (ss = ((Criteria.ResultMapCriteria)mappable).sourceScript()) != null) {
                            parsed = Parser.get(ss);
                        }
                        if (parsed != null) {
                            if (BaseTypeFilter.isBaseType(key, bb.getValue(), parsed)) {
                                ite.remove();
                            } else {
                                BeanElement be = parsed.getElement(key);
                                if (be != null) {
                                    TimestampSupport.testNumberValueToDate(be.getClz(), bb);
                                    if (bb.getValue() == null) {
                                        ite.remove();
                                    }
                                }
                            }
                        }
                    }
                } else if (p == Op.IN || p == Op.NOT_IN) {
                    List valueList = (List)bb.getValue();
                    if (valueList.size() > 1) continue;
                    if (key.contains(".")) {
                        if (BaseTypeFilter.isBaseType(key, valueList.get(0), mappable)) {
                            ite.remove();
                        }
                    } else {
                        Parsed parsed = mappable.getParsed();
                        if (parsed != null && BaseTypeFilter.isBaseType(key, valueList.get(0), parsed)) {
                            ite.remove();
                        }
                    }
                }
                if ((subList = bb.getSubList()) == null || subList.isEmpty()) continue;
                this.filter(subList, mappable);
            }
        }
    }
}

