/*
 * Copyright (c) 2018 Practice Insight Pty Ltd. All Rights Reserved.
 */

package io.wisetime.wise_log_aws.cloud;

import java.util.Optional;

/**
 * Immutable config object for use in writer/filter.
 */
class ConfigPojo {

  private String moduleName;
  private String logGroupName;

  private int flushIntervalInSeconds = 4;

  int getFlushIntervalInSeconds() {
    return flushIntervalInSeconds;
  }

  Optional<String> getModuleName() {
    return Optional.ofNullable(moduleName);
  }

  Optional<String> getLogGroupName() {
    return Optional.ofNullable(logGroupName);
  }

  @SuppressWarnings("WeakerAccess")
  static final class ConfigPojoBuilder {
    private int flushIntervalInSeconds = 3;
    private String moduleName;
    private String defaultLogGroup;

    private ConfigPojoBuilder() {
    }

    public static ConfigPojoBuilder aConfigPojo() {
      return new ConfigPojoBuilder();
    }

    public ConfigPojoBuilder withFlushIntervalInSeconds(int flushIntervalInSeconds) {
      this.flushIntervalInSeconds = flushIntervalInSeconds;
      return this;
    }

    public ConfigPojoBuilder withDefaultLogGroup(String defaultLogGroup) {
      this.defaultLogGroup = defaultLogGroup;
      return this;
    }

    public ConfigPojoBuilder withModuleName(String moduleName) {
      this.moduleName = moduleName;
      return this;
    }

    public ConfigPojo build() {
      ConfigPojo configPojo = new ConfigPojo();
      configPojo.moduleName = this.moduleName;
      configPojo.logGroupName = this.defaultLogGroup;
      configPojo.flushIntervalInSeconds = this.flushIntervalInSeconds;
      return configPojo;
    }
  }
}
