/*
 * Decompiled with CFR 0.152.
 */
package com.zackehh.jackson.datatype.hadoop;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VIntWritable;
import org.apache.hadoop.io.VLongWritable;
import org.apache.hadoop.io.Writable;

class HadoopSerializers {
    HadoopSerializers() {
    }

    static class VLongSerializer
    extends JsonSerializer<VLongWritable> {
        VLongSerializer() {
        }

        public void serialize(VLongWritable value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNumber(value.get());
        }
    }

    static class VIntSerializer
    extends JsonSerializer<VIntWritable> {
        VIntSerializer() {
        }

        public void serialize(VIntWritable value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNumber(value.get());
        }
    }

    static class TextSerializer
    extends JsonSerializer<Text> {
        TextSerializer() {
        }

        public void serialize(Text value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObject((Object)value.toString());
        }
    }

    static class ShortSerializer
    extends JsonSerializer<ShortWritable> {
        ShortSerializer() {
        }

        public void serialize(ShortWritable value, JsonGenerator jgen, SerializerProvider serializers) throws IOException {
            jgen.writeNumber(value.get());
        }
    }

    static class NullSerializer
    extends JsonSerializer<NullWritable> {
        NullSerializer() {
        }

        public void serialize(NullWritable value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNull();
        }
    }

    static class MD5HashSerializer
    extends JsonSerializer<MD5Hash> {
        MD5HashSerializer() {
        }

        public void serialize(MD5Hash value, JsonGenerator jgen, SerializerProvider serializers) throws IOException {
            jgen.writeObject((Object)value.getDigest());
        }
    }

    static class MapSerializer
    extends JsonSerializer<MapWritable> {
        MapSerializer() {
        }

        public void serialize(MapWritable value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            for (Map.Entry e : value.entrySet()) {
                jgen.writeObjectField(e.getKey().toString(), e.getValue());
            }
            jgen.writeEndObject();
        }
    }

    static class LongSerializer
    extends JsonSerializer<LongWritable> {
        LongSerializer() {
        }

        public void serialize(LongWritable value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNumber(value.get());
        }
    }

    static class IntSerializer
    extends JsonSerializer<IntWritable> {
        IntSerializer() {
        }

        public void serialize(IntWritable value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNumber(value.get());
        }
    }

    static class FloatSerializer
    extends JsonSerializer<FloatWritable> {
        FloatSerializer() {
        }

        public void serialize(FloatWritable value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNumber(value.get());
        }
    }

    static class DoubleSerializer
    extends JsonSerializer<DoubleWritable> {
        DoubleSerializer() {
        }

        public void serialize(DoubleWritable value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNumber(value.get());
        }
    }

    static class BytesSerializer
    extends JsonSerializer<BytesWritable> {
        BytesSerializer() {
        }

        public void serialize(BytesWritable value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeBinary(value.getBytes(), 0, value.getCapacity());
        }
    }

    static class ByteSerializer
    extends JsonSerializer<ByteWritable> {
        ByteSerializer() {
        }

        public synchronized void serialize(ByteWritable value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNumber((short)value.get());
        }
    }

    static class BooleanSerializer
    extends JsonSerializer<BooleanWritable> {
        BooleanSerializer() {
        }

        public void serialize(BooleanWritable value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeBoolean(value.get());
        }
    }

    static class ArraySerializer
    extends JsonSerializer<ArrayWritable> {
        ArraySerializer() {
        }

        public void serialize(ArrayWritable value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartArray();
            for (Writable w : value.get()) {
                jgen.writeObject((Object)w);
            }
            jgen.writeEndArray();
        }
    }
}

