/*
 * Decompiled with CFR 0.152.
 */
package io.whitfin.elasticsearch.bulk;

import io.whitfin.elasticsearch.bulk.BulkLifecycle;
import io.whitfin.elasticsearch.bulk.BulkOperator;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.elasticsearch.client.RestClient;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableBulkOperator
extends BulkOperator {
    private final RestClient client;
    private final int concurrency;
    private final BulkLifecycle lifecycle;
    @Nullable
    private final Integer interval;
    @Nullable
    private final Integer maxActions;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBulkOperator(Builder builder) {
        this.client = builder.client;
        this.interval = builder.interval;
        this.maxActions = builder.maxActions;
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.lifecycle != null) {
            this.initShim.lifecycle(builder.lifecycle);
        }
        this.concurrency = this.initShim.concurrency();
        this.lifecycle = this.initShim.lifecycle();
        this.initShim = null;
    }

    @Override
    public RestClient client() {
        return this.client;
    }

    @Override
    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    @Override
    public BulkLifecycle lifecycle() {
        InitShim shim = this.initShim;
        return shim != null ? shim.lifecycle() : this.lifecycle;
    }

    @Override
    @Nullable
    public Integer interval() {
        return this.interval;
    }

    @Override
    @Nullable
    public Integer maxActions() {
        return this.maxActions;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBulkOperator && this.equalTo((ImmutableBulkOperator)another);
    }

    private boolean equalTo(ImmutableBulkOperator another) {
        return this.client.equals(another.client) && this.concurrency == another.concurrency && this.lifecycle.equals(another.lifecycle) && Objects.equals(this.interval, another.interval) && Objects.equals(this.maxActions, another.maxActions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.client.hashCode();
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.lifecycle.hashCode();
        h += (h << 5) + Objects.hashCode(this.interval);
        h += (h << 5) + Objects.hashCode(this.maxActions);
        return h;
    }

    public String toString() {
        return "BulkOperator{client=" + this.client + ", concurrency=" + this.concurrency + ", lifecycle=" + this.lifecycle + ", interval=" + this.interval + ", maxActions=" + this.maxActions + "}";
    }

    private static ImmutableBulkOperator validate(ImmutableBulkOperator instance) {
        instance = (ImmutableBulkOperator)instance.validate();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder
    implements BulkOperator.Builder {
        private static final long INIT_BIT_CLIENT = 1L;
        private static final long OPT_BIT_CONCURRENCY = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private RestClient client;
        private int concurrency;
        @Nullable
        private BulkLifecycle lifecycle;
        @Nullable
        private Integer interval;
        @Nullable
        private Integer maxActions;

        private Builder() {
        }

        public final Builder from(BulkOperator instance) {
            Integer maxActionsValue;
            Objects.requireNonNull(instance, "instance");
            this.client(instance.client());
            this.concurrency(instance.concurrency());
            this.lifecycle(instance.lifecycle());
            Integer intervalValue = instance.interval();
            if (intervalValue != null) {
                this.interval(intervalValue);
            }
            if ((maxActionsValue = instance.maxActions()) != null) {
                this.maxActions(maxActionsValue);
            }
            return this;
        }

        @Override
        public final Builder client(RestClient client) {
            this.client = Objects.requireNonNull(client, "client");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 1L;
            return this;
        }

        @Override
        public final Builder lifecycle(BulkLifecycle lifecycle) {
            this.lifecycle = Objects.requireNonNull(lifecycle, "lifecycle");
            return this;
        }

        @Override
        public final Builder interval(@Nullable Integer interval) {
            this.interval = interval;
            return this;
        }

        @Override
        public final Builder maxActions(@Nullable Integer maxActions) {
            this.maxActions = maxActions;
            return this;
        }

        @Override
        public ImmutableBulkOperator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableBulkOperator.validate(new ImmutableBulkOperator(this));
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("client");
            }
            return "Cannot build BulkOperator, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private int concurrency;
        private int concurrencyBuildStage;
        private BulkLifecycle lifecycle;
        private int lifecycleBuildStage;

        private InitShim() {
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = -1;
                this.concurrency = ImmutableBulkOperator.super.concurrency();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        BulkLifecycle lifecycle() {
            if (this.lifecycleBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lifecycleBuildStage == 0) {
                this.lifecycleBuildStage = -1;
                this.lifecycle = Objects.requireNonNull(ImmutableBulkOperator.super.lifecycle(), "lifecycle");
                this.lifecycleBuildStage = 1;
            }
            return this.lifecycle;
        }

        void lifecycle(BulkLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            this.lifecycleBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.lifecycleBuildStage == -1) {
                attributes.add("lifecycle");
            }
            return "Cannot build BulkOperator, attribute initializers form cycle" + attributes;
        }
    }
}

