/*
 * Decompiled with CFR 0.152.
 */
package io.whitfin.elasticsearch.bulk;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.whitfin.elasticsearch.bulk.BulkAction;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableBulkAction
extends BulkAction {
    private final String operation;
    @Nullable
    private final String index;
    @Nullable
    private final String type;
    @Nullable
    private final String id;
    @Nullable
    private final String parent;
    @Nullable
    private final String routing;
    @Nullable
    private final String source;
    @Nullable
    private final Integer version;
    @Nullable
    private final String versionType;
    @Nullable
    private final Boolean refresh;
    @Nullable
    private final Boolean waitForActiveShards;

    private ImmutableBulkAction(Builder builder) {
        this.operation = builder.operation;
        this.index = builder.index;
        this.type = builder.type;
        this.id = builder.id;
        this.parent = builder.parent;
        this.routing = builder.routing;
        this.source = builder.source;
        this.version = builder.version;
        this.versionType = builder.versionType;
        this.refresh = builder.refresh;
        this.waitForActiveShards = builder.waitForActiveShards;
    }

    @Override
    @JsonProperty(value="operation")
    public String operation() {
        return this.operation;
    }

    @Override
    @JsonProperty(value="index")
    @Nullable
    public String index() {
        return this.index;
    }

    @Override
    @JsonProperty(value="type")
    @Nullable
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="parent")
    @Nullable
    public String parent() {
        return this.parent;
    }

    @Override
    @JsonProperty(value="routing")
    @Nullable
    public String routing() {
        return this.routing;
    }

    @Override
    @JsonProperty(value="source")
    @Nullable
    public String source() {
        return this.source;
    }

    @Override
    @JsonProperty(value="version")
    @Nullable
    public Integer version() {
        return this.version;
    }

    @Override
    @JsonProperty(value="versionType")
    @Nullable
    public String versionType() {
        return this.versionType;
    }

    @Override
    @JsonProperty(value="refresh")
    @Nullable
    public Boolean refresh() {
        return this.refresh;
    }

    @Override
    @JsonProperty(value="waitForActiveShards")
    @Nullable
    public Boolean waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBulkAction && this.equalTo((ImmutableBulkAction)another);
    }

    private boolean equalTo(ImmutableBulkAction another) {
        return this.operation.equals(another.operation) && Objects.equals(this.index, another.index) && Objects.equals(this.type, another.type) && Objects.equals(this.id, another.id) && Objects.equals(this.parent, another.parent) && Objects.equals(this.routing, another.routing) && Objects.equals(this.source, another.source) && Objects.equals(this.version, another.version) && Objects.equals(this.versionType, another.versionType) && Objects.equals(this.refresh, another.refresh) && Objects.equals(this.waitForActiveShards, another.waitForActiveShards);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.operation.hashCode();
        h += (h << 5) + Objects.hashCode(this.index);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.parent);
        h += (h << 5) + Objects.hashCode(this.routing);
        h += (h << 5) + Objects.hashCode(this.source);
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + Objects.hashCode(this.versionType);
        h += (h << 5) + Objects.hashCode(this.refresh);
        h += (h << 5) + Objects.hashCode(this.waitForActiveShards);
        return h;
    }

    public String toString() {
        return "BulkAction{operation=" + this.operation + ", index=" + this.index + ", type=" + this.type + ", id=" + this.id + ", parent=" + this.parent + ", routing=" + this.routing + ", source=" + this.source + ", version=" + this.version + ", versionType=" + this.versionType + ", refresh=" + this.refresh + ", waitForActiveShards=" + this.waitForActiveShards + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBulkAction fromJson(Json json) {
        Builder builder = ImmutableBulkAction.builder();
        if (json.operation != null) {
            builder.operation(json.operation);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.parent != null) {
            builder.parent(json.parent);
        }
        if (json.routing != null) {
            builder.routing(json.routing);
        }
        if (json.source != null) {
            builder.source(json.source);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.versionType != null) {
            builder.versionType(json.versionType);
        }
        if (json.refresh != null) {
            builder.refresh(json.refresh);
        }
        if (json.waitForActiveShards != null) {
            builder.waitForActiveShards(json.waitForActiveShards);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder
    implements BulkAction.Builder {
        private static final long INIT_BIT_OPERATION = 1L;
        private long initBits = 1L;
        @Nullable
        private String operation;
        @Nullable
        private String index;
        @Nullable
        private String type;
        @Nullable
        private String id;
        @Nullable
        private String parent;
        @Nullable
        private String routing;
        @Nullable
        private String source;
        @Nullable
        private Integer version;
        @Nullable
        private String versionType;
        @Nullable
        private Boolean refresh;
        @Nullable
        private Boolean waitForActiveShards;

        private Builder() {
        }

        public final Builder from(BulkAction instance) {
            Boolean waitForActiveShardsValue;
            Boolean refreshValue;
            String versionTypeValue;
            Integer versionValue;
            String sourceValue;
            String routingValue;
            String parentValue;
            String idValue;
            String typeValue;
            Objects.requireNonNull(instance, "instance");
            this.operation(instance.operation());
            String indexValue = instance.index();
            if (indexValue != null) {
                this.index(indexValue);
            }
            if ((typeValue = instance.type()) != null) {
                this.type(typeValue);
            }
            if ((idValue = instance.id()) != null) {
                this.id(idValue);
            }
            if ((parentValue = instance.parent()) != null) {
                this.parent(parentValue);
            }
            if ((routingValue = instance.routing()) != null) {
                this.routing(routingValue);
            }
            if ((sourceValue = instance.source()) != null) {
                this.source(sourceValue);
            }
            if ((versionValue = instance.version()) != null) {
                this.version(versionValue);
            }
            if ((versionTypeValue = instance.versionType()) != null) {
                this.versionType(versionTypeValue);
            }
            if ((refreshValue = instance.refresh()) != null) {
                this.refresh(refreshValue);
            }
            if ((waitForActiveShardsValue = instance.waitForActiveShards()) != null) {
                this.waitForActiveShards(waitForActiveShardsValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="operation")
        public final Builder operation(String operation) {
            this.operation = Objects.requireNonNull(operation, "operation");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="index")
        public final Builder index(@Nullable String index) {
            this.index = index;
            return this;
        }

        @Override
        @JsonProperty(value="type")
        public final Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        @Override
        @JsonProperty(value="id")
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonProperty(value="parent")
        public final Builder parent(@Nullable String parent) {
            this.parent = parent;
            return this;
        }

        @Override
        @JsonProperty(value="routing")
        public final Builder routing(@Nullable String routing) {
            this.routing = routing;
            return this;
        }

        @Override
        @JsonProperty(value="source")
        public final Builder source(@Nullable String source) {
            this.source = source;
            return this;
        }

        @Override
        @JsonProperty(value="version")
        public final Builder version(@Nullable Integer version) {
            this.version = version;
            return this;
        }

        @Override
        @JsonProperty(value="versionType")
        public final Builder versionType(@Nullable String versionType) {
            this.versionType = versionType;
            return this;
        }

        @Override
        @JsonProperty(value="refresh")
        public final Builder refresh(@Nullable Boolean refresh) {
            this.refresh = refresh;
            return this;
        }

        @Override
        @JsonProperty(value="waitForActiveShards")
        public final Builder waitForActiveShards(@Nullable Boolean waitForActiveShards) {
            this.waitForActiveShards = waitForActiveShards;
            return this;
        }

        @Override
        public ImmutableBulkAction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBulkAction(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("operation");
            }
            return "Cannot build BulkAction, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends BulkAction {
        @Nullable
        String operation;
        @Nullable
        String index;
        @Nullable
        String type;
        @Nullable
        String id;
        @Nullable
        String parent;
        @Nullable
        String routing;
        @Nullable
        String source;
        @Nullable
        Integer version;
        @Nullable
        String versionType;
        @Nullable
        Boolean refresh;
        @Nullable
        Boolean waitForActiveShards;

        Json() {
        }

        @JsonProperty(value="operation")
        public void setOperation(String operation) {
            this.operation = operation;
        }

        @JsonProperty(value="index")
        public void setIndex(@Nullable String index) {
            this.index = index;
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="parent")
        public void setParent(@Nullable String parent) {
            this.parent = parent;
        }

        @JsonProperty(value="routing")
        public void setRouting(@Nullable String routing) {
            this.routing = routing;
        }

        @JsonProperty(value="source")
        public void setSource(@Nullable String source) {
            this.source = source;
        }

        @JsonProperty(value="version")
        public void setVersion(@Nullable Integer version) {
            this.version = version;
        }

        @JsonProperty(value="versionType")
        public void setVersionType(@Nullable String versionType) {
            this.versionType = versionType;
        }

        @JsonProperty(value="refresh")
        public void setRefresh(@Nullable Boolean refresh) {
            this.refresh = refresh;
        }

        @JsonProperty(value="waitForActiveShards")
        public void setWaitForActiveShards(@Nullable Boolean waitForActiveShards) {
            this.waitForActiveShards = waitForActiveShards;
        }

        @Override
        public String operation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String index() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String parent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String routing() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String source() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer version() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String versionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean refresh() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean waitForActiveShards() {
            throw new UnsupportedOperationException();
        }
    }
}

