/*
 * Decompiled with CFR 0.152.
 */
package io.whitfin.elasticsearch.bulk;

import io.whitfin.elasticsearch.bulk.BulkAction;
import io.whitfin.elasticsearch.bulk.BulkLifecycle;
import io.whitfin.elasticsearch.bulk.BulkOperation;
import io.whitfin.elasticsearch.bulk.ImmutableBulkOperator;
import io.whitfin.elasticsearch.bulk.lifecycle.NoopLifecycle;
import java.io.Closeable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.entity.NStringEntity;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.immutables.value.Value;

@Value.Immutable(copy=false)
@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE)
public abstract class BulkOperator
implements Closeable {
    private static final AtomicLong IDENTIFIERS = new AtomicLong();
    private static final Header ND_JSON_HEADER = new BasicHeader("content-type", "application/x-ndjson");
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private volatile Integer current;
    private Boolean closed;
    private BulkOperation.Builder operation;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture scheduledFuture;
    private Semaphore mutex;

    public abstract RestClient client();

    @Value.Default
    public int concurrency() {
        return 1;
    }

    @Value.Default
    public BulkLifecycle lifecycle() {
        return new NoopLifecycle();
    }

    @Nullable
    public abstract Integer interval();

    @Nullable
    public abstract Integer maxActions();

    @Value.Check
    BulkOperator validate() {
        BulkOperator initializedOperator = this.concurrency() > 0 ? this : ImmutableBulkOperator.builder().from(this).concurrency(1).build();
        return initializedOperator.init();
    }

    private synchronized BulkOperator init() {
        this.current = 0;
        this.closed = false;
        this.mutex = new Semaphore(this.concurrency());
        this.operation = BulkOperation.builder();
        Integer interval = this.interval();
        if (interval == null) {
            return this;
        }
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                BulkOperator.this.flush();
            }
        }, interval.intValue(), interval.intValue(), TimeUnit.MILLISECONDS);
        return this;
    }

    public synchronized BulkOperator add(BulkAction ... bulkActions) {
        if (this.closed.booleanValue()) {
            throw new IllegalStateException("BulkOperator already closed");
        }
        BulkOperator bulkOperator = this;
        Integer n = bulkOperator.current;
        Integer n2 = bulkOperator.current = Integer.valueOf(bulkOperator.current + 1);
        this.operation.addAction(bulkActions);
        Integer maxActions = this.maxActions();
        if (maxActions != null && this.current >= maxActions) {
            this.flush();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        BulkOperation bulkOperation;
        if (this.closed.booleanValue() || this.current == 0) {
            return;
        }
        BulkOperator bulkOperator = this;
        synchronized (bulkOperator) {
            bulkOperation = this.operation.build();
            this.current = 0;
            this.operation.actions(Collections.emptyList());
        }
        try {
            this.mutex.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        long bulkId = IDENTIFIERS.incrementAndGet();
        BulkResponseListener responseListener = new BulkResponseListener(bulkId, bulkOperation);
        NStringEntity entity = new NStringEntity(bulkOperation.payload(), ContentType.APPLICATION_JSON);
        this.lifecycle().beforeBulk(bulkId, this, bulkOperation);
        this.client().performRequestAsync("POST", "/_bulk", EMPTY_MAP, (HttpEntity)entity, (ResponseListener)responseListener, new Header[]{ND_JSON_HEADER});
    }

    @Override
    public synchronized void close() {
        if (this.closed.booleanValue()) {
            return;
        }
        this.closed = true;
        if (this.scheduler != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
            this.scheduler.shutdown();
            this.scheduler = null;
        }
    }

    public static Builder builder(@Nonnull RestClient client) {
        return ImmutableBulkOperator.builder().client(client);
    }

    private class BulkResponseListener
    implements ResponseListener {
        private final long id;
        private final BulkOperation operation;

        private BulkResponseListener(@Nonnull long id, BulkOperation operation) {
            this.id = id;
            this.operation = Objects.requireNonNull(operation);
        }

        public void onSuccess(final Response response) {
            this.execAndRelease(new Runnable(){

                @Override
                public void run() {
                    BulkOperator.this.lifecycle().afterBulk(BulkResponseListener.this.id, BulkOperator.this, BulkResponseListener.this.operation, response);
                }
            });
        }

        public void onFailure(final Exception exception) {
            this.execAndRelease(new Runnable(){

                @Override
                public void run() {
                    BulkOperator.this.lifecycle().afterBulk(BulkResponseListener.this.id, BulkOperator.this, BulkResponseListener.this.operation, exception);
                }
            });
        }

        private void execAndRelease(Runnable block) {
            try {
                block.run();
            }
            finally {
                BulkOperator.this.mutex.release();
            }
        }
    }

    public static interface Builder {
        public Builder client(RestClient var1);

        public Builder concurrency(int var1);

        public Builder interval(Integer var1);

        public Builder lifecycle(BulkLifecycle var1);

        public Builder maxActions(Integer var1);

        public BulkOperator build();
    }
}

