/*
 * Decompiled with CFR 0.152.
 */
package io.whitfin.elasticsearch.bulk.lifecycle;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.whitfin.elasticsearch.bulk.BulkAction;
import io.whitfin.elasticsearch.bulk.BulkOperation;
import io.whitfin.elasticsearch.bulk.BulkOperator;
import io.whitfin.elasticsearch.bulk.lifecycle.NoopLifecycle;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.client.Response;

public class RequeueLifecycle
extends NoopLifecycle {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public void afterBulk(long executionId, BulkOperator operator, BulkOperation operation, Response response) {
        JsonNode bulkResponse;
        try {
            bulkResponse = MAPPER.readTree(response.getEntity().getContent());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (!bulkResponse.path("errors").asBoolean()) {
            return;
        }
        JsonNode itemsArray = bulkResponse.path("items");
        List<BulkAction> attempt = operation.actions();
        int j = itemsArray.size();
        for (int i = 0; i < j; ++i) {
            if (itemsArray.get(i).path("index").path("status").asInt() < 400) continue;
            operator.add(attempt.get(i));
        }
    }
}

