/*
 * Decompiled with CFR 0.152.
 */
package io.whitfin.elasticsearch.bulk;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.whitfin.elasticsearch.bulk.BulkAction;
import io.whitfin.elasticsearch.bulk.BulkOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableBulkOperation
extends BulkOperation {
    private final List<BulkAction> actions;
    private final long estimatedSizeInBytes;
    private final long numberOfActions;
    private final String payload;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBulkOperation(Builder builder) {
        this.actions = ImmutableBulkOperation.createUnmodifiableList(true, builder.actions);
        this.estimatedSizeInBytes = this.initShim.estimatedSizeInBytes();
        this.numberOfActions = this.initShim.numberOfActions();
        this.payload = this.initShim.payload();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="actions")
    public List<BulkAction> actions() {
        return this.actions;
    }

    @Override
    @JsonProperty(value="estimatedSizeInBytes")
    public long estimatedSizeInBytes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.estimatedSizeInBytes() : this.estimatedSizeInBytes;
    }

    @Override
    @JsonProperty(value="numberOfActions")
    public long numberOfActions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.numberOfActions() : this.numberOfActions;
    }

    @Override
    @JsonProperty(value="payload")
    public String payload() {
        InitShim shim = this.initShim;
        return shim != null ? shim.payload() : this.payload;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBulkOperation && this.equalTo((ImmutableBulkOperation)another);
    }

    private boolean equalTo(ImmutableBulkOperation another) {
        return this.actions.equals(another.actions) && this.estimatedSizeInBytes == another.estimatedSizeInBytes && this.numberOfActions == another.numberOfActions && this.payload.equals(another.payload);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.actions.hashCode();
        h += (h << 5) + (int)(this.estimatedSizeInBytes ^ this.estimatedSizeInBytes >>> 32);
        h += (h << 5) + (int)(this.numberOfActions ^ this.numberOfActions >>> 32);
        h += (h << 5) + this.payload.hashCode();
        return h;
    }

    public String toString() {
        return "BulkOperation{actions=" + this.actions + ", estimatedSizeInBytes=" + this.estimatedSizeInBytes + ", numberOfActions=" + this.numberOfActions + ", payload=" + this.payload + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBulkOperation fromJson(Json json) {
        BulkOperation.Builder builder = new BulkOperation.Builder();
        if (json.actions != null) {
            builder.addAllActions(json.actions);
        }
        return builder.build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static class Builder {
        private List<BulkAction> actions = new ArrayList<BulkAction>();

        public Builder() {
            if (!(this instanceof BulkOperation.Builder)) {
                throw new UnsupportedOperationException("Use: new BulkOperation.Builder()");
            }
        }

        public final BulkOperation.Builder from(BulkOperation instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllActions(instance.actions());
            return (BulkOperation.Builder)this;
        }

        public final BulkOperation.Builder addAction(BulkAction element) {
            this.actions.add(Objects.requireNonNull(element, "actions element"));
            return (BulkOperation.Builder)this;
        }

        public final BulkOperation.Builder addAction(BulkAction ... elements) {
            for (BulkAction element : elements) {
                this.actions.add(Objects.requireNonNull(element, "actions element"));
            }
            return (BulkOperation.Builder)this;
        }

        @JsonProperty(value="actions")
        public final BulkOperation.Builder actions(Iterable<? extends BulkAction> elements) {
            this.actions.clear();
            return this.addAllActions(elements);
        }

        public final BulkOperation.Builder addAllActions(Iterable<? extends BulkAction> elements) {
            for (BulkAction bulkAction : elements) {
                this.actions.add(Objects.requireNonNull(bulkAction, "actions element"));
            }
            return (BulkOperation.Builder)this;
        }

        public ImmutableBulkOperation build() {
            return new ImmutableBulkOperation(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends BulkOperation {
        @Nullable
        List<BulkAction> actions = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="actions")
        public void setActions(List<BulkAction> actions) {
            this.actions = actions;
        }

        @Override
        public List<BulkAction> actions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long estimatedSizeInBytes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long numberOfActions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String payload() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private long estimatedSizeInBytes;
        private int estimatedSizeInBytesBuildStage;
        private long numberOfActions;
        private int numberOfActionsBuildStage;
        private String payload;
        private int payloadBuildStage;

        private InitShim() {
        }

        long estimatedSizeInBytes() {
            if (this.estimatedSizeInBytesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.estimatedSizeInBytesBuildStage == 0) {
                this.estimatedSizeInBytesBuildStage = -1;
                this.estimatedSizeInBytes = ImmutableBulkOperation.super.estimatedSizeInBytes();
                this.estimatedSizeInBytesBuildStage = 1;
            }
            return this.estimatedSizeInBytes;
        }

        long numberOfActions() {
            if (this.numberOfActionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.numberOfActionsBuildStage == 0) {
                this.numberOfActionsBuildStage = -1;
                this.numberOfActions = ImmutableBulkOperation.super.numberOfActions();
                this.numberOfActionsBuildStage = 1;
            }
            return this.numberOfActions;
        }

        String payload() {
            if (this.payloadBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.payloadBuildStage == 0) {
                this.payloadBuildStage = -1;
                this.payload = Objects.requireNonNull(ImmutableBulkOperation.super.payload(), "payload");
                this.payloadBuildStage = 1;
            }
            return this.payload;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.estimatedSizeInBytesBuildStage == -1) {
                attributes.add("estimatedSizeInBytes");
            }
            if (this.numberOfActionsBuildStage == -1) {
                attributes.add("numberOfActions");
            }
            if (this.payloadBuildStage == -1) {
                attributes.add("payload");
            }
            return "Cannot build BulkOperation, attribute initializers form cycle" + attributes;
        }
    }
}

