/*
 * Decompiled with CFR 0.152.
 */
package io.whitfin.elasticsearch.bulk;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.whitfin.elasticsearch.bulk.BulkAction;
import io.whitfin.elasticsearch.bulk.ImmutableBulkOperation;
import java.util.List;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableBulkOperation.class)
@JsonDeserialize(as=ImmutableBulkOperation.class)
@Value.Immutable(copy=false)
@Value.Style(depluralize=true, visibility=Value.Style.ImplementationVisibility.PACKAGE)
public abstract class BulkOperation {
    public abstract List<BulkAction> actions();

    @Value.Derived
    public long estimatedSizeInBytes() {
        return this.payload().length();
    }

    @Value.Derived
    public long numberOfActions() {
        return this.actions().size();
    }

    @Value.Derived
    public String payload() {
        StringBuilder builder = new StringBuilder();
        for (BulkAction action : this.actions()) {
            ObjectNode contentBuilder = JsonNodeFactory.instance.objectNode();
            ObjectNode operationBuilder = contentBuilder.with(action.operation());
            if (action.index() != null) {
                operationBuilder.put("_index", action.index());
            }
            if (action.type() != null) {
                operationBuilder.put("_type", action.type());
            }
            if (action.id() != null) {
                operationBuilder.put("_id", action.id());
            }
            if (action.parent() != null) {
                operationBuilder.put("_parent", action.parent());
            }
            if (action.routing() != null) {
                operationBuilder.put("_routing", action.routing());
            }
            if (action.version() != null) {
                operationBuilder.put("_version", action.version());
            }
            if (action.refresh() != null) {
                operationBuilder.put("refresh", action.refresh());
            }
            if (action.waitForActiveShards() != null) {
                operationBuilder.put("wait_for_active_shards", action.waitForActiveShards());
            }
            builder.append(contentBuilder.toString());
            builder.append("\n");
            builder.append(action.source());
            builder.append("\n");
        }
        return builder.toString();
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder
    extends ImmutableBulkOperation.Builder {
        Builder() {
        }
    }
}

