package io.whitfin.elasticsearch.bulk;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.elasticsearch.client.RestClient;

/**
 * Immutable implementation of {@link BulkOperator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new BulkOperator.Builder()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "BulkOperator"})
@Immutable
final class ImmutableBulkOperator extends BulkOperator {
  private final RestClient client;
  private final int concurrency;
  private final BulkLifecycle lifecycle;
  private final @Nullable Integer interval;
  private final @Nullable Integer maxActions;

  private ImmutableBulkOperator(ImmutableBulkOperator.Builder builder) {
    this.client = builder.client;
    this.interval = builder.interval;
    this.maxActions = builder.maxActions;
    if (builder.concurrencyIsSet()) {
      initShim.concurrency(builder.concurrency);
    }
    if (builder.lifecycle != null) {
      initShim.lifecycle(builder.lifecycle);
    }
    this.concurrency = initShim.concurrency();
    this.lifecycle = initShim.lifecycle();
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private int concurrency;
    private int concurrencyBuildStage;

    int concurrency() {
      if (concurrencyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (concurrencyBuildStage == STAGE_UNINITIALIZED) {
        concurrencyBuildStage = STAGE_INITIALIZING;
        this.concurrency = ImmutableBulkOperator.super.concurrency();
        concurrencyBuildStage = STAGE_INITIALIZED;
      }
      return this.concurrency;
    }

    void concurrency(int concurrency) {
      this.concurrency = concurrency;
      concurrencyBuildStage = STAGE_INITIALIZED;
    }
    private BulkLifecycle lifecycle;
    private int lifecycleBuildStage;

    BulkLifecycle lifecycle() {
      if (lifecycleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (lifecycleBuildStage == STAGE_UNINITIALIZED) {
        lifecycleBuildStage = STAGE_INITIALIZING;
        this.lifecycle = Objects.requireNonNull(ImmutableBulkOperator.super.lifecycle(), "lifecycle");
        lifecycleBuildStage = STAGE_INITIALIZED;
      }
      return this.lifecycle;
    }

    void lifecycle(BulkLifecycle lifecycle) {
      this.lifecycle = lifecycle;
      lifecycleBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (concurrencyBuildStage == STAGE_INITIALIZING) attributes.add("concurrency");
      if (lifecycleBuildStage == STAGE_INITIALIZING) attributes.add("lifecycle");
      return "Cannot build BulkOperator, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * @return The value of the {@code client} attribute
   */
  @Override
  public RestClient client() {
    return client;
  }

  /**
   * @return The value of the {@code concurrency} attribute
   */
  @Override
  public int concurrency() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.concurrency()
        : this.concurrency;
  }

  /**
   * @return The value of the {@code lifecycle} attribute
   */
  @Override
  public BulkLifecycle lifecycle() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.lifecycle()
        : this.lifecycle;
  }

  /**
   * @return The value of the {@code interval} attribute
   */
  @Override
  public @Nullable Integer interval() {
    return interval;
  }

  /**
   * @return The value of the {@code maxActions} attribute
   */
  @Override
  public @Nullable Integer maxActions() {
    return maxActions;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBulkOperator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBulkOperator
        && equalTo((ImmutableBulkOperator) another);
  }

  private boolean equalTo(ImmutableBulkOperator another) {
    return client.equals(another.client)
        && concurrency == another.concurrency
        && lifecycle.equals(another.lifecycle)
        && Objects.equals(interval, another.interval)
        && Objects.equals(maxActions, another.maxActions);
  }

  /**
   * Computes a hash code from attributes: {@code client}, {@code concurrency}, {@code lifecycle}, {@code interval}, {@code maxActions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + client.hashCode();
    h += (h << 5) + concurrency;
    h += (h << 5) + lifecycle.hashCode();
    h += (h << 5) + Objects.hashCode(interval);
    h += (h << 5) + Objects.hashCode(maxActions);
    return h;
  }

  /**
   * Prints the immutable value {@code BulkOperator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BulkOperator{"
        + "client=" + client
        + ", concurrency=" + concurrency
        + ", lifecycle=" + lifecycle
        + ", interval=" + interval
        + ", maxActions=" + maxActions
        + "}";
  }


  private static ImmutableBulkOperator validate(ImmutableBulkOperator instance) {
    instance = (ImmutableBulkOperator) instance.validate();
    return instance;
  }

  /**
   * Builds instances of type {@link ImmutableBulkOperator ImmutableBulkOperator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_CLIENT = 0x1L;
    private static final long OPT_BIT_CONCURRENCY = 0x1L;
    private long initBits = 0x1L;
    private long optBits;

    private @Nullable RestClient client;
    private int concurrency;
    private @Nullable BulkLifecycle lifecycle;
    private @Nullable Integer interval;
    private @Nullable Integer maxActions;

    /**
     * Creates a builder for {@link ImmutableBulkOperator ImmutableBulkOperator} instances.
     */
    public Builder() {
      if (!(this instanceof BulkOperator.Builder)) {
        throw new UnsupportedOperationException("Use: new BulkOperator.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code BulkOperator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final BulkOperator.Builder from(BulkOperator instance) {
      Objects.requireNonNull(instance, "instance");
      client(instance.client());
      concurrency(instance.concurrency());
      lifecycle(instance.lifecycle());
      @Nullable Integer intervalValue = instance.interval();
      if (intervalValue != null) {
        interval(intervalValue);
      }
      @Nullable Integer maxActionsValue = instance.maxActions();
      if (maxActionsValue != null) {
        maxActions(maxActionsValue);
      }
      return (BulkOperator.Builder) this;
    }

    /**
     * Initializes the value for the {@link BulkOperator#client() client} attribute.
     * @param client The value for client 
     * @return {@code this} builder for use in a chained invocation
     */
    public final BulkOperator.Builder client(RestClient client) {
      this.client = Objects.requireNonNull(client, "client");
      initBits &= ~INIT_BIT_CLIENT;
      return (BulkOperator.Builder) this;
    }

    /**
     * Initializes the value for the {@link BulkOperator#concurrency() concurrency} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link BulkOperator#concurrency() concurrency}.</em>
     * @param concurrency The value for concurrency 
     * @return {@code this} builder for use in a chained invocation
     */
    public final BulkOperator.Builder concurrency(int concurrency) {
      this.concurrency = concurrency;
      optBits |= OPT_BIT_CONCURRENCY;
      return (BulkOperator.Builder) this;
    }

    /**
     * Initializes the value for the {@link BulkOperator#lifecycle() lifecycle} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link BulkOperator#lifecycle() lifecycle}.</em>
     * @param lifecycle The value for lifecycle 
     * @return {@code this} builder for use in a chained invocation
     */
    public final BulkOperator.Builder lifecycle(BulkLifecycle lifecycle) {
      this.lifecycle = Objects.requireNonNull(lifecycle, "lifecycle");
      return (BulkOperator.Builder) this;
    }

    /**
     * Initializes the value for the {@link BulkOperator#interval() interval} attribute.
     * @param interval The value for interval (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final BulkOperator.Builder interval(@Nullable Integer interval) {
      this.interval = interval;
      return (BulkOperator.Builder) this;
    }

    /**
     * Initializes the value for the {@link BulkOperator#maxActions() maxActions} attribute.
     * @param maxActions The value for maxActions (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final BulkOperator.Builder maxActions(@Nullable Integer maxActions) {
      this.maxActions = maxActions;
      return (BulkOperator.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableBulkOperator ImmutableBulkOperator}.
     * @return An immutable instance of BulkOperator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBulkOperator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableBulkOperator.validate(new ImmutableBulkOperator(this));
    }

    private boolean concurrencyIsSet() {
      return (optBits & OPT_BIT_CONCURRENCY) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_CLIENT) != 0) attributes.add("client");
      return "Cannot build BulkOperator, some of required attributes are not set " + attributes;
    }
  }
}
