package io.whitfin.elasticsearch.bulk;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link BulkAction}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new BulkAction.Builder()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "BulkAction"})
@Immutable
final class ImmutableBulkAction extends BulkAction {
  private final String operation;
  private final @Nullable String index;
  private final @Nullable String type;
  private final @Nullable String id;
  private final @Nullable String parent;
  private final @Nullable String routing;
  private final @Nullable String source;
  private final @Nullable Integer version;
  private final @Nullable Boolean refresh;
  private final @Nullable Boolean waitForActiveShards;

  private ImmutableBulkAction(ImmutableBulkAction.Builder builder) {
    this.operation = builder.operation;
    this.index = builder.index;
    this.type = builder.type;
    this.id = builder.id;
    this.parent = builder.parent;
    this.routing = builder.routing;
    this.source = builder.source;
    this.version = builder.version;
    this.refresh = builder.refresh;
    this.waitForActiveShards = builder.waitForActiveShards;
  }

  /**
   * @return The value of the {@code operation} attribute
   */
  @JsonProperty("operation")
  @Override
  public String operation() {
    return operation;
  }

  /**
   * @return The value of the {@code index} attribute
   */
  @JsonProperty("index")
  @Override
  public @Nullable String index() {
    return index;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public @Nullable String type() {
    return type;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public @Nullable String id() {
    return id;
  }

  /**
   * @return The value of the {@code parent} attribute
   */
  @JsonProperty("parent")
  @Override
  public @Nullable String parent() {
    return parent;
  }

  /**
   * @return The value of the {@code routing} attribute
   */
  @JsonProperty("routing")
  @Override
  public @Nullable String routing() {
    return routing;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @JsonProperty("source")
  @Override
  public @Nullable String source() {
    return source;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public @Nullable Integer version() {
    return version;
  }

  /**
   * @return The value of the {@code refresh} attribute
   */
  @JsonProperty("refresh")
  @Override
  public @Nullable Boolean refresh() {
    return refresh;
  }

  /**
   * @return The value of the {@code waitForActiveShards} attribute
   */
  @JsonProperty("waitForActiveShards")
  @Override
  public @Nullable Boolean waitForActiveShards() {
    return waitForActiveShards;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBulkAction} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBulkAction
        && equalTo((ImmutableBulkAction) another);
  }

  private boolean equalTo(ImmutableBulkAction another) {
    return operation.equals(another.operation)
        && Objects.equals(index, another.index)
        && Objects.equals(type, another.type)
        && Objects.equals(id, another.id)
        && Objects.equals(parent, another.parent)
        && Objects.equals(routing, another.routing)
        && Objects.equals(source, another.source)
        && Objects.equals(version, another.version)
        && Objects.equals(refresh, another.refresh)
        && Objects.equals(waitForActiveShards, another.waitForActiveShards);
  }

  /**
   * Computes a hash code from attributes: {@code operation}, {@code index}, {@code type}, {@code id}, {@code parent}, {@code routing}, {@code source}, {@code version}, {@code refresh}, {@code waitForActiveShards}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + operation.hashCode();
    h += (h << 5) + Objects.hashCode(index);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(parent);
    h += (h << 5) + Objects.hashCode(routing);
    h += (h << 5) + Objects.hashCode(source);
    h += (h << 5) + Objects.hashCode(version);
    h += (h << 5) + Objects.hashCode(refresh);
    h += (h << 5) + Objects.hashCode(waitForActiveShards);
    return h;
  }

  /**
   * Prints the immutable value {@code BulkAction} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BulkAction{"
        + "operation=" + operation
        + ", index=" + index
        + ", type=" + type
        + ", id=" + id
        + ", parent=" + parent
        + ", routing=" + routing
        + ", source=" + source
        + ", version=" + version
        + ", refresh=" + refresh
        + ", waitForActiveShards=" + waitForActiveShards
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends BulkAction {
    @Nullable String operation;
    @Nullable String index;
    @Nullable String type;
    @Nullable String id;
    @Nullable String parent;
    @Nullable String routing;
    @Nullable String source;
    @Nullable Integer version;
    @Nullable Boolean refresh;
    @Nullable Boolean waitForActiveShards;
    @JsonProperty("operation")
    public void setOperation(String operation) {
      this.operation = operation;
    }
    @JsonProperty("index")
    public void setIndex(@Nullable String index) {
      this.index = index;
    }
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty("id")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("parent")
    public void setParent(@Nullable String parent) {
      this.parent = parent;
    }
    @JsonProperty("routing")
    public void setRouting(@Nullable String routing) {
      this.routing = routing;
    }
    @JsonProperty("source")
    public void setSource(@Nullable String source) {
      this.source = source;
    }
    @JsonProperty("version")
    public void setVersion(@Nullable Integer version) {
      this.version = version;
    }
    @JsonProperty("refresh")
    public void setRefresh(@Nullable Boolean refresh) {
      this.refresh = refresh;
    }
    @JsonProperty("waitForActiveShards")
    public void setWaitForActiveShards(@Nullable Boolean waitForActiveShards) {
      this.waitForActiveShards = waitForActiveShards;
    }
    @Override
    public String operation() { throw new UnsupportedOperationException(); }
    @Override
    public String index() { throw new UnsupportedOperationException(); }
    @Override
    public String type() { throw new UnsupportedOperationException(); }
    @Override
    public String id() { throw new UnsupportedOperationException(); }
    @Override
    public String parent() { throw new UnsupportedOperationException(); }
    @Override
    public String routing() { throw new UnsupportedOperationException(); }
    @Override
    public String source() { throw new UnsupportedOperationException(); }
    @Override
    public Integer version() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean refresh() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean waitForActiveShards() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableBulkAction fromJson(Json json) {
    BulkAction.Builder builder = new BulkAction.Builder();
    if (json.operation != null) {
      builder.operation(json.operation);
    }
    if (json.index != null) {
      builder.index(json.index);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.parent != null) {
      builder.parent(json.parent);
    }
    if (json.routing != null) {
      builder.routing(json.routing);
    }
    if (json.source != null) {
      builder.source(json.source);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.refresh != null) {
      builder.refresh(json.refresh);
    }
    if (json.waitForActiveShards != null) {
      builder.waitForActiveShards(json.waitForActiveShards);
    }
    return (ImmutableBulkAction) builder.build();
  }

  /**
   * Builds instances of type {@link ImmutableBulkAction ImmutableBulkAction}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_OPERATION = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String operation;
    private @Nullable String index;
    private @Nullable String type;
    private @Nullable String id;
    private @Nullable String parent;
    private @Nullable String routing;
    private @Nullable String source;
    private @Nullable Integer version;
    private @Nullable Boolean refresh;
    private @Nullable Boolean waitForActiveShards;

    /**
     * Creates a builder for {@link ImmutableBulkAction ImmutableBulkAction} instances.
     */
    public Builder() {
      if (!(this instanceof BulkAction.Builder)) {
        throw new UnsupportedOperationException("Use: new BulkAction.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code BulkAction} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final BulkAction.Builder from(BulkAction instance) {
      Objects.requireNonNull(instance, "instance");
      operation(instance.operation());
      @Nullable String indexValue = instance.index();
      if (indexValue != null) {
        index(indexValue);
      }
      @Nullable String typeValue = instance.type();
      if (typeValue != null) {
        type(typeValue);
      }
      @Nullable String idValue = instance.id();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable String parentValue = instance.parent();
      if (parentValue != null) {
        parent(parentValue);
      }
      @Nullable String routingValue = instance.routing();
      if (routingValue != null) {
        routing(routingValue);
      }
      @Nullable String sourceValue = instance.source();
      if (sourceValue != null) {
        source(sourceValue);
      }
      @Nullable Integer versionValue = instance.version();
      if (versionValue != null) {
        version(versionValue);
      }
      @Nullable Boolean refreshValue = instance.refresh();
      if (refreshValue != null) {
        refresh(refreshValue);
      }
      @Nullable Boolean waitForActiveShardsValue = instance.waitForActiveShards();
      if (waitForActiveShardsValue != null) {
        waitForActiveShards(waitForActiveShardsValue);
      }
      return (BulkAction.Builder) this;
    }

    /**
     * Initializes the value for the {@link BulkAction#operation() operation} attribute.
     * @param operation The value for operation 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("operation")
    public final BulkAction.Builder operation(String operation) {
      this.operation = Objects.requireNonNull(operation, "operation");
      initBits &= ~INIT_BIT_OPERATION;
      return (BulkAction.Builder) this;
    }

    /**
     * Initializes the value for the {@link BulkAction#index() index} attribute.
     * @param index The value for index (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("index")
    public final BulkAction.Builder index(@Nullable String index) {
      this.index = index;
      return (BulkAction.Builder) this;
    }

    /**
     * Initializes the value for the {@link BulkAction#type() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final BulkAction.Builder type(@Nullable String type) {
      this.type = type;
      return (BulkAction.Builder) this;
    }

    /**
     * Initializes the value for the {@link BulkAction#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final BulkAction.Builder id(@Nullable String id) {
      this.id = id;
      return (BulkAction.Builder) this;
    }

    /**
     * Initializes the value for the {@link BulkAction#parent() parent} attribute.
     * @param parent The value for parent (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("parent")
    public final BulkAction.Builder parent(@Nullable String parent) {
      this.parent = parent;
      return (BulkAction.Builder) this;
    }

    /**
     * Initializes the value for the {@link BulkAction#routing() routing} attribute.
     * @param routing The value for routing (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("routing")
    public final BulkAction.Builder routing(@Nullable String routing) {
      this.routing = routing;
      return (BulkAction.Builder) this;
    }

    /**
     * Initializes the value for the {@link BulkAction#source() source} attribute.
     * @param source The value for source (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("source")
    public final BulkAction.Builder source(@Nullable String source) {
      this.source = source;
      return (BulkAction.Builder) this;
    }

    /**
     * Initializes the value for the {@link BulkAction#version() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final BulkAction.Builder version(@Nullable Integer version) {
      this.version = version;
      return (BulkAction.Builder) this;
    }

    /**
     * Initializes the value for the {@link BulkAction#refresh() refresh} attribute.
     * @param refresh The value for refresh (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("refresh")
    public final BulkAction.Builder refresh(@Nullable Boolean refresh) {
      this.refresh = refresh;
      return (BulkAction.Builder) this;
    }

    /**
     * Initializes the value for the {@link BulkAction#waitForActiveShards() waitForActiveShards} attribute.
     * @param waitForActiveShards The value for waitForActiveShards (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("waitForActiveShards")
    public final BulkAction.Builder waitForActiveShards(@Nullable Boolean waitForActiveShards) {
      this.waitForActiveShards = waitForActiveShards;
      return (BulkAction.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableBulkAction ImmutableBulkAction}.
     * @return An immutable instance of BulkAction
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBulkAction build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBulkAction(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_OPERATION) != 0) attributes.add("operation");
      return "Cannot build BulkAction, some of required attributes are not set " + attributes;
    }
  }
}
