/*
 * Decompiled with CFR 0.152.
 */
package io.whitfin.elasticsearch.bulk;

import io.whitfin.elasticsearch.bulk.BulkAction;
import io.whitfin.elasticsearch.bulk.BulkLifecycle;
import io.whitfin.elasticsearch.bulk.BulkOperation;
import io.whitfin.elasticsearch.bulk.ImmutableBulkOperation;
import io.whitfin.elasticsearch.bulk.lifecycle.NoopLifecycle;
import java.io.Closeable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.entity.NStringEntity;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;

public class BulkOperator
implements Closeable {
    private static final AtomicLong IDENTIFIERS = new AtomicLong();
    private static final Header ND_JSON_HEADER = new BasicHeader("content-type", "application/x-ndjson");
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private final BulkLifecycle lifecycle;
    private final Integer maxActions;
    private final RestClient client;
    private final ScheduledExecutorService scheduler;
    private final ScheduledFuture scheduledFuture;
    private final Semaphore semaphore;
    private volatile Integer current;
    private Boolean closed;
    private BulkOperation.Builder operation;

    private BulkOperator(Builder builder) {
        this.client = builder.client;
        this.lifecycle = builder.lifecycle;
        this.maxActions = builder.maxActions;
        this.semaphore = new Semaphore(builder.concurrency);
        this.current = 0;
        this.closed = false;
        this.operation = BulkOperation.builder();
        if (builder.interval != null) {
            this.scheduler = Executors.newScheduledThreadPool(1);
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    BulkOperator.this.flush();
                }
            }, builder.interval, builder.interval, TimeUnit.MILLISECONDS);
        } else {
            this.scheduler = null;
            this.scheduledFuture = null;
        }
    }

    public synchronized BulkOperator add(BulkAction ... bulkActions) {
        if (this.closed.booleanValue()) {
            throw new IllegalStateException("BulkOperator already closed");
        }
        BulkOperator bulkOperator = this;
        Integer n = bulkOperator.current;
        Integer n2 = bulkOperator.current = Integer.valueOf(bulkOperator.current + 1);
        this.operation.addAction(bulkActions);
        if (this.maxActions != null && this.current >= this.maxActions) {
            this.flush();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ImmutableBulkOperation bulkOperation;
        if (this.closed.booleanValue() || this.current == 0) {
            return;
        }
        BulkOperator bulkOperator = this;
        synchronized (bulkOperator) {
            bulkOperation = this.operation.build();
            this.current = 0;
            this.operation = BulkOperation.builder();
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        long bulkId = IDENTIFIERS.incrementAndGet();
        BulkResponseListener responseListener = new BulkResponseListener(bulkId, bulkOperation);
        NStringEntity entity = new NStringEntity(((BulkOperation)bulkOperation).payload(), ContentType.APPLICATION_JSON);
        this.lifecycle.beforeBulk(bulkId, this, bulkOperation);
        this.client.performRequestAsync("POST", "/_bulk", EMPTY_MAP, (HttpEntity)entity, (ResponseListener)responseListener, new Header[]{ND_JSON_HEADER});
    }

    @Override
    public synchronized void close() {
        if (this.closed.booleanValue()) {
            return;
        }
        this.closed = true;
        if (this.scheduler != null) {
            this.scheduledFuture.cancel(true);
            this.scheduler.shutdown();
        }
    }

    public static Builder builder(RestClient client) {
        return new Builder(client);
    }

    public static class Builder {
        private int concurrency = 1;
        private BulkLifecycle lifecycle = new NoopLifecycle();
        private Integer maxActions;
        private Long interval;
        private RestClient client;

        Builder(@Nonnull RestClient client) {
            this.client = Objects.requireNonNull(client);
        }

        public Builder concurrency(int concurrency) {
            this.concurrency = concurrency < 1 ? 1 : concurrency;
            return this;
        }

        public Builder interval(long interval) {
            this.interval = interval;
            return this;
        }

        public Builder lifecycle(@Nonnull BulkLifecycle lifecycle) {
            this.lifecycle = Objects.requireNonNull(lifecycle);
            return this;
        }

        public Builder maxActions(@Nullable Integer maxActions) {
            this.maxActions = maxActions;
            return this;
        }

        public BulkOperator build() {
            return new BulkOperator(this);
        }
    }

    private class BulkResponseListener
    implements ResponseListener {
        private final long id;
        private final BulkOperation operation;

        private BulkResponseListener(@Nonnull long id, BulkOperation operation) {
            this.id = id;
            this.operation = Objects.requireNonNull(operation);
        }

        public void onSuccess(final Response response) {
            this.execAndRelease(new Runnable(){

                @Override
                public void run() {
                    BulkOperator.this.lifecycle.afterBulk(BulkResponseListener.this.id, BulkOperator.this, BulkResponseListener.this.operation, response);
                }
            });
        }

        public void onFailure(final Exception exception) {
            this.execAndRelease(new Runnable(){

                @Override
                public void run() {
                    BulkOperator.this.lifecycle.afterBulk(BulkResponseListener.this.id, BulkOperator.this, BulkResponseListener.this.operation, exception);
                }
            });
        }

        private void execAndRelease(Runnable block) {
            try {
                block.run();
            }
            finally {
                BulkOperator.this.semaphore.release();
            }
        }
    }
}

