/*
 * Decompiled with CFR 0.152.
 */
package io.whitfin.dottie.splitter;

import io.whitfin.dottie.exception.NotationException;
import io.whitfin.dottie.parser.NotationParser;
import io.whitfin.dottie.segment.NotationSegment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class NotationSplitter {
    @Nonnull
    public static List<NotationSegment> split(@Nonnull String input) {
        Objects.requireNonNull(input);
        int position = 0;
        ArrayList<NotationSegment> keys = new ArrayList<NotationSegment>();
        while (!input.isEmpty()) {
            boolean hasSafeProps;
            boolean isDot;
            String prop = NotationParser.findSegment(input);
            if (prop == null) {
                throw new NotationException(input, input.charAt(0), position);
            }
            keys.add(NotationParser.parseSegment(prop));
            int inputLen = input.length();
            int propLen = prop.length();
            if (inputLen == propLen) {
                input = "";
                continue;
            }
            String remainder = input.substring(propLen);
            boolean bl = isDot = remainder.charAt(0) == '.';
            if (remainder.length() < 2) {
                throw new NotationException("Unable to parse key with trailing " + (isDot ? "dot" : "bracket") + "!");
            }
            char nextChar = remainder.charAt(1);
            String nextCharStr = String.valueOf(nextChar);
            boolean bl2 = hasSafeProps = isDot ? NotationParser.isAccessor(nextCharStr) : NotationParser.isPropertyOpener(nextChar);
            if (!hasSafeProps) {
                throw new NotationException(input, nextChar, position + propLen + 1);
            }
            if (isDot) {
                remainder = remainder.substring(1);
            }
            position += inputLen - remainder.length();
            input = remainder;
        }
        return keys;
    }
}

