/*
 * Decompiled with CFR 0.152.
 */
package io.whitfin.dottie.segment;

import io.whitfin.dottie.parser.NotationParser;
import io.whitfin.dottie.segment.NotationAccessor;
import io.whitfin.dottie.segment.NotationIndex;
import io.whitfin.dottie.segment.NotationProperty;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class NotationSegment<T> {
    private final T value;

    NotationSegment(@Nonnull T value) {
        this.value = Objects.requireNonNull(value);
    }

    @Nonnull
    public abstract String escape();

    @Nonnull
    public NotationSegment<Integer> asIndex() {
        return this;
    }

    @Nonnull
    public NotationSegment<String> asProperty() {
        return this;
    }

    public boolean isIndex() {
        return this.type() == Integer.class;
    }

    public boolean isProperty() {
        return this.type() == String.class;
    }

    @Nonnull
    public Class<T> type() {
        return this.value.getClass();
    }

    @Nonnull
    public T value() {
        return this.value;
    }

    @Nonnull
    public static NotationSegment parse(@Nonnull Integer index) {
        return new NotationIndex(Objects.requireNonNull(index));
    }

    @Nonnull
    public static NotationSegment parse(@Nonnull String property) {
        return NotationParser.isAccessor(Objects.requireNonNull(property)) ? new NotationAccessor(property) : new NotationProperty(property);
    }
}

