/*
 * Decompiled with CFR 0.152.
 */
package io.whitfin.dottie.parser;

import io.whitfin.dottie.segment.NotationSegment;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NotationParser {
    private static final Set<Character> OPENERS = new HashSet<Character>();
    private static final Pattern ACCESSOR;
    private static final Pattern INDEX;
    private static final Pattern PROPERTY;
    private static final Pattern SEGMENT;
    private static final Pattern CLOSED_SEGMENT;

    @Nullable
    public static String findSegment(@Nonnull String input) {
        return NotationParser.findFirstMatch(input, SEGMENT);
    }

    public static boolean isAccessor(@Nonnull String input) {
        return NotationParser.isPattern(input, ACCESSOR);
    }

    public static boolean isIndex(@Nonnull String input) {
        return NotationParser.isPattern(input, INDEX);
    }

    public static boolean isProperty(@Nonnull String input) {
        return NotationParser.isPattern(input, PROPERTY);
    }

    public static boolean isPropertyOpener(char input) {
        return OPENERS.contains(Character.valueOf(input));
    }

    public static boolean isSegment(@Nonnull String input) {
        return NotationParser.isPattern(input, CLOSED_SEGMENT);
    }

    public static NotationSegment parseSegment(@Nonnull String segment) {
        Objects.requireNonNull(segment);
        String tmp = NotationParser.findFirstMatch(segment, ACCESSOR);
        if (tmp != null) {
            return NotationSegment.parse(tmp);
        }
        tmp = NotationParser.findFirstMatch(segment, INDEX);
        if (tmp != null) {
            return NotationSegment.parse(Integer.parseInt(tmp));
        }
        tmp = NotationParser.findFirstMatch(segment, PROPERTY);
        if (tmp != null) {
            return NotationSegment.parse(tmp);
        }
        throw new IllegalStateException();
    }

    @Nullable
    private static String findFirstMatch(String input, Pattern pattern) {
        Matcher matcher = pattern.matcher(input);
        return matcher.find() ? matcher.group(1) : null;
    }

    private static boolean isPattern(String input, Pattern pattern) {
        return pattern.matcher(input).find();
    }

    static {
        for (int i = 48; i < 58; ++i) {
            OPENERS.add(Character.valueOf((char)i));
        }
        OPENERS.add(Character.valueOf('\"'));
        OPENERS.add(Character.valueOf('\''));
        ACCESSOR = Pattern.compile("^([a-zA-Z_$][a-zA-Z0-9_$]*)$");
        INDEX = Pattern.compile("^\\[([0-9]+)]$");
        PROPERTY = Pattern.compile("^\\[(?:'|\")(.*)(?:'|\")]$");
        SEGMENT = Pattern.compile("^((?:[a-zA-Z_$][a-zA-Z0-9_$]*)|(?:\\[(?:'.*?(?='])'|\".*?(?=\"])\")])|(?:\\[\\d+]))");
        CLOSED_SEGMENT = Pattern.compile(SEGMENT.toString() + "$");
    }
}

