/*
 * Decompiled with CFR 0.152.
 */
package io.whitfin.dottie.joiner;

import io.whitfin.dottie.segment.NotationSegment;
import java.util.Objects;
import javax.annotation.Nonnull;

public class NotationJoiner {
    private final StringBuilder internalBuilder = new StringBuilder();
    private boolean started;

    public NotationJoiner() {
        this.reset();
    }

    @Nonnull
    public NotationJoiner append(Integer ... indices) {
        for (Integer index : Objects.requireNonNull(indices)) {
            this.append(NotationSegment.parse(index));
        }
        return this;
    }

    @Nonnull
    public NotationJoiner append(NotationSegment ... segments) {
        for (NotationSegment segment : Objects.requireNonNull(segments)) {
            String escapedKey = Objects.requireNonNull(segment).escape();
            if (this.started) {
                if (escapedKey.charAt(0) != '[') {
                    this.internalBuilder.append(".");
                }
            } else {
                this.started = true;
            }
            this.internalBuilder.append(escapedKey);
        }
        return this;
    }

    @Nonnull
    public NotationJoiner append(String ... properties) {
        for (String property : Objects.requireNonNull(properties)) {
            this.append(NotationSegment.parse(property));
        }
        return this;
    }

    @Nonnull
    public String print() {
        return this.internalBuilder.toString();
    }

    @Nonnull
    public NotationJoiner reset() {
        this.internalBuilder.setLength(0);
        this.started = false;
        return this;
    }

    @Nonnull
    public String toString() {
        return this.print();
    }
}

