/*
 * Decompiled with CFR 0.152.
 */
package com.zackehh.dotnotes;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.zackehh.dotnotes.DotCursor;
import com.zackehh.dotnotes.DotUtils;
import com.zackehh.dotnotes.util.NotedHandler;
import com.zackehh.dotnotes.util.NotedKey;
import com.zackehh.dotnotes.util.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DotNotes {
    private static final JsonNodeFactory factory = JsonNodeFactory.instance;

    private DotNotes() {
        throw new UnsupportedOperationException();
    }

    public static JsonNode create(String path, JsonNode value) throws ParseException {
        return DotNotes.create(path, value, null);
    }

    public static JsonNode create(String path, JsonNode value, JsonNode target) throws ParseException {
        JsonNode targetNode;
        List<NotedKey> keys = DotNotes.keys(path);
        JsonNode tmp = targetNode = target == null ? (keys.get(0).isNumber() ? factory.arrayNode() : factory.objectNode()) : target;
        int j = keys.size() - 1;
        for (int i = 0; i < j; ++i) {
            NotedKey key = keys.get(i);
            NotedKey nextKey = i < j - 1 ? keys.get(i + 1) : null;
            MissingNode local = MissingNode.getInstance();
            if (key.isString()) {
                local = tmp.path(key.asString());
            }
            if (key.isNumber()) {
                local = tmp.path(key.asNumber().intValue());
            }
            if (local.isMissingNode()) {
                if (nextKey != null) {
                    DotUtils.set(tmp, key, (JsonNode)(nextKey.isNumber() ? factory.arrayNode() : factory.objectNode()));
                } else {
                    DotUtils.set(tmp, key, (JsonNode)factory.objectNode());
                }
            }
            if (key.isString()) {
                tmp = tmp.path(key.asString());
            }
            if (!key.isNumber()) continue;
            tmp = tmp.path(key.asNumber().intValue());
        }
        NotedKey endKey = keys.get(keys.size() - 1);
        DotUtils.set(tmp, endKey, value);
        return targetNode;
    }

    public static ObjectNode flatten(JsonNode node) {
        final ObjectNode targetNode = factory.objectNode();
        DotNotes.notedCursor(node, new NotedHandler(){

            @Override
            public void execute(String path, JsonNode value) {
                targetNode.set(path, value);
            }
        });
        return targetNode;
    }

    public static JsonNode get(String path, JsonNode node) throws ParseException {
        node = node == null ? MissingNode.getInstance() : node;
        List<NotedKey> keys = DotNotes.keys(path);
        JsonNode tmp = node;
        int k = keys.size() - 1;
        for (int i = 0; i < k; ++i) {
            NotedKey key = keys.get(i);
            if (key.isString()) {
                tmp = tmp.path(key.asString());
            }
            if (key.isNumber()) {
                tmp = tmp.path(key.asNumber().intValue());
            }
            if (!tmp.isMissingNode()) continue;
            return tmp;
        }
        NotedKey key = keys.get(keys.size() - 1);
        if (key.isNumber()) {
            return tmp.path(key.asNumber().intValue());
        }
        return tmp.path(key.asString());
    }

    public static JsonNode inflate(ObjectNode node) throws ParseException {
        return DotNotes.inflate(node, null);
    }

    public static JsonNode inflate(ObjectNode node, ObjectNode target) throws ParseException {
        target = target == null ? factory.objectNode() : target;
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            DotNotes.create((String)entry.getKey(), (JsonNode)entry.getValue(), (JsonNode)target);
        }
        return target;
    }

    public static List<NotedKey> keys(String s) throws ParseException {
        ArrayList<NotedKey> keys = new ArrayList<NotedKey>();
        int len = s.length();
        int p = 0;
        while (p < len) {
            char nc;
            int c = s.indexOf(93, p);
            int d = s.indexOf(".", p);
            int b = s.indexOf("[", p);
            if (d == -1 && b == -1 && !DotUtils.isQuote(s.charAt(p))) {
                keys.add(NotedKey.of(s.substring(p, len)));
                break;
            }
            if (b == -1 || d != -1 && d < b) {
                if (s.charAt(d + 1) == '.') {
                    throw new ParseException(s.charAt(d + 1), d + 1, false);
                }
                if (c == -1 || d != -1 && d < c) {
                    keys.add(NotedKey.of(s.substring(p, d)));
                } else {
                    if (d < c) {
                        d = c + 1;
                    }
                    if (DotUtils.isQuote(s.charAt(p))) {
                        keys.add(NotedKey.of(s.substring(p + 1, d - 2)));
                    } else {
                        keys.add(NotedKey.of(DotUtils.parseNum(s.substring(p, d - 1))));
                    }
                }
                p = d + 1;
                continue;
            }
            if (b > p) {
                char nb = s.charAt(b - 2);
                if (DotUtils.isQuote(nb)) {
                    keys.add(NotedKey.of(s.substring(p + 1, b - 2)));
                } else {
                    keys.add(NotedKey.of(s.substring(p, b)));
                }
                p = b;
            }
            if (!DotUtils.isQuote(nc = s.charAt(b + 1))) {
                c = s.indexOf(93, b);
                if (c < 0 || c == b + 1 || !s.substring(b + 1, c).matches("^\\d+$")) {
                    throw new ParseException(nc, b + 1, true);
                }
                keys.add(NotedKey.of(DotUtils.parseNum(s.substring(b + 1, c))));
                p = c + 2;
                continue;
            }
            c = s.indexOf(s.charAt(b + 1) + "]", b);
            if (c == -1) {
                throw new ParseException("Unable to find matching quote at column " + (b + 1) + "!");
            }
            keys.add(NotedKey.of(s.substring(p + 2, c)));
            p = c + (len > c + 2 && s.charAt(c + 2) == '.' ? 3 : 2);
        }
        return keys;
    }

    public static void notedCursor(JsonNode node, NotedHandler handler) {
        DotCursor.recurse(node, handler, null);
    }
}

