/*
 * Decompiled with CFR 0.152.
 */
package com.zackehh.dotnotes;

import com.fasterxml.jackson.databind.JsonNode;
import com.zackehh.dotnotes.util.NotedHandler;
import com.zackehh.dotnotes.util.NotedKey;
import java.util.Iterator;

class DotCursor {
    private DotCursor() {
        throw new UnsupportedOperationException();
    }

    public static void recurse(JsonNode node, NotedHandler handler, String path) {
        if (node.isObject()) {
            Iterator names = node.fieldNames();
            while (names.hasNext()) {
                DotCursor.iterate(node, NotedKey.of(names.next()), path, handler);
            }
        } else {
            int j = node.size();
            for (int i = 0; i < j; ++i) {
                DotCursor.iterate(node, NotedKey.of(i), path, handler);
            }
        }
    }

    private static void execOrRecurse(JsonNode o, NotedKey k, String p, NotedHandler h) {
        JsonNode node = DotCursor.findNode(o, k);
        if (node.isContainerNode()) {
            DotCursor.recurse(node, h, p);
        } else {
            h.execute(p, node);
        }
    }

    private static JsonNode findNode(JsonNode o, NotedKey k) {
        if (k.isNumber()) {
            return o.path(k.asNumber().intValue());
        }
        return o.path(k.asString());
    }

    private static void iterate(JsonNode o, NotedKey k, String p, NotedHandler h) {
        String keyStub;
        String key = k.toString();
        String string = keyStub = p == null ? "" : p;
        if (o.isArray()) {
            DotCursor.execOrRecurse(o, k, keyStub + '[' + k + ']', h);
            return;
        }
        DotCursor.execOrRecurse(o, k, keyStub + (key.contains(".") ? "['" + key + "']" : (p != null ? "." + key : key)), h);
    }
}

