/*
 * Decompiled with CFR 0.152.
 */
package io.webinv.avprobe.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AvprobeStream {
    private int index;
    @JsonProperty(value="codec_name")
    private String codecName;
    @JsonProperty(value="codec_long_name")
    private String codecLongName;
    @JsonProperty(value="codec_type")
    private String codecType;
    @JsonProperty(value="codec_time_base")
    private String codecTimeBase;
    @JsonProperty(value="codec_tag_string")
    private String codecTagString;
    @JsonProperty(value="codec_tag")
    private String codecTag;
    @JsonProperty(value="sample_rate")
    private Double sampleRate;
    private Integer channels;
    @JsonProperty(value="bits_per_sample")
    private String bitsPerSample;
    private String profile;
    private String width;
    private String height;
    @JsonProperty(value="has_b_frames")
    private String hasBFrames;
    @JsonProperty(value="sample_aspect_ratio")
    private String sampleAspectRatio;
    @JsonProperty(value="display_aspect_ratio")
    private String displayAspectRatio;
    @JsonProperty(value="pix_fmt")
    private String pixFmt;
    private String level;
    @JsonProperty(value="avg_frame_rate")
    private String avgFrameRate;
    @JsonProperty(value="bit_rate")
    private Double bitRate;
    @JsonProperty(value="time_base")
    private String timeBase;
    @JsonProperty(value="start_time")
    private Double startTime;
    private Double duration;
    @JsonProperty(value="nb_frames")
    private Integer nbFrames;
    private Map<String, String> tags;

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public void setCodecName(String codecName) {
        this.codecName = codecName;
    }

    public String getCodecLongName() {
        return this.codecLongName;
    }

    public void setCodecLongName(String codecLongName) {
        this.codecLongName = codecLongName;
    }

    public String getCodecType() {
        return this.codecType;
    }

    public void setCodecType(String codecType) {
        this.codecType = codecType;
    }

    public String getCodecTimeBase() {
        return this.codecTimeBase;
    }

    public void setCodecTimeBase(String codecTimeBase) {
        this.codecTimeBase = codecTimeBase;
    }

    public String getCodecTagString() {
        return this.codecTagString;
    }

    public void setCodecTagString(String codecTagString) {
        this.codecTagString = codecTagString;
    }

    public String getCodecTag() {
        return this.codecTag;
    }

    public void setCodecTag(String codecTag) {
        this.codecTag = codecTag;
    }

    public Double getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(Double sampleRate) {
        this.sampleRate = sampleRate;
    }

    public Integer getChannels() {
        return this.channels;
    }

    public void setChannels(Integer channels) {
        this.channels = channels;
    }

    public String getBitsPerSample() {
        return this.bitsPerSample;
    }

    public void setBitsPerSample(String bitsPerSample) {
        this.bitsPerSample = bitsPerSample;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getHasBFrames() {
        return this.hasBFrames;
    }

    public void setHasBFrames(String hasBFrames) {
        this.hasBFrames = hasBFrames;
    }

    public String getSampleAspectRatio() {
        return this.sampleAspectRatio;
    }

    public void setSampleAspectRatio(String sampleAspectRatio) {
        this.sampleAspectRatio = sampleAspectRatio;
    }

    public String getDisplayAspectRatio() {
        return this.displayAspectRatio;
    }

    public void setDisplayAspectRatio(String displayAspectRatio) {
        this.displayAspectRatio = displayAspectRatio;
    }

    public String getPixFmt() {
        return this.pixFmt;
    }

    public void setPixFmt(String pixFmt) {
        this.pixFmt = pixFmt;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getAvgFrameRate() {
        return this.avgFrameRate;
    }

    public void setAvgFrameRate(String avgFrameRate) {
        this.avgFrameRate = avgFrameRate;
    }

    public Double getBitRate() {
        return this.bitRate;
    }

    public void setBitRate(Double bitRate) {
        this.bitRate = bitRate;
    }

    public String getTimeBase() {
        return this.timeBase;
    }

    public void setTimeBase(String timeBase) {
        this.timeBase = timeBase;
    }

    public Double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Double startTime) {
        this.startTime = startTime;
    }

    public Double getDuration() {
        return this.duration;
    }

    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public Integer getNbFrames() {
        return this.nbFrames;
    }

    public void setNbFrames(Integer nbFrames) {
        this.nbFrames = nbFrames;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public boolean isCodecType(CodecType type) {
        CodecType codecType = CodecType.getCodecTypeOf(this.codecType);
        return null != codecType && type.equals((Object)codecType);
    }

    public static enum CodecType {
        AUDIO,
        VIDEO;


        public static CodecType getCodecTypeOf(String value) {
            if (null == value || value.isEmpty()) {
                return null;
            }
            String formatted = value.toUpperCase();
            for (CodecType type : CodecType.values()) {
                if (!type.toString().equals(formatted)) continue;
                return type;
            }
            return null;
        }
    }
}

