/*
 * Decompiled with CFR 0.152.
 */
package io.webinv.avprobe.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.webinv.avprobe.domain.AvprobeFormat;
import io.webinv.avprobe.domain.AvprobeStream;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AvprobeResult {
    private AvprobeFormat format;
    private List<AvprobeStream> streams;

    public AvprobeFormat getFormat() {
        return this.format;
    }

    public void setFormat(AvprobeFormat format) {
        this.format = format;
    }

    public List<AvprobeStream> getStreams() {
        return this.streams;
    }

    public void setStreams(List<AvprobeStream> streams) {
        this.streams = streams;
    }

    public AvprobeStream getStreamAudio() {
        return this.getStreamByCodecType(AvprobeStream.CodecType.AUDIO);
    }

    public AvprobeStream getStreamVideo() {
        return this.getStreamByCodecType(AvprobeStream.CodecType.VIDEO);
    }

    public AvprobeStream getStreamByCodecType(AvprobeStream.CodecType codecType) {
        if (null == this.streams || this.streams.isEmpty()) {
            return null;
        }
        for (AvprobeStream stream : this.streams) {
            if (!stream.isCodecType(codecType)) continue;
            return stream;
        }
        return null;
    }

    public boolean containsStreamByCodecType(AvprobeStream.CodecType codecType) {
        return null != this.getStreamByCodecType(codecType);
    }

    public boolean containsStreamAudio() {
        return this.containsStreamByCodecType(AvprobeStream.CodecType.AUDIO);
    }

    public boolean containsStreamVideo() {
        return this.containsStreamByCodecType(AvprobeStream.CodecType.VIDEO);
    }

    public boolean containsStreamAudioVideo() {
        return this.containsStreamVideo() && this.containsStreamAudio();
    }
}

