/*
 * Decompiled with CFR 0.152.
 */
package io.webinv.avprobe;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.webinv.avprobe.domain.AvprobeResult;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Avprobe {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private String avprobePath = "avprobe";

    public String getAvprobePath() {
        return this.avprobePath;
    }

    public void setAvprobePath(String avprobePath) {
        this.avprobePath = avprobePath;
    }

    public AvprobeResult getInfo(String filepath) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(this.getAvprobePath(), "-v", "quiet", "-show_format", "-show_streams", "-of", "json", filepath);
        this.logger.debug(pb.command());
        pb.redirectErrorStream(false);
        Process p = pb.start();
        InputStream is = p.getInputStream();
        p.waitFor();
        String results = IOUtils.toString((InputStream)is, (Charset)Charset.forName("UTF-8"));
        this.logger.debug(results);
        if (0 == p.exitValue()) {
            return (AvprobeResult)new ObjectMapper().readValue(results, AvprobeResult.class);
        }
        this.logger.error("Command: {}, exit code: {}, Results: {}", (Object)String.join((CharSequence)" ", pb.command()), (Object)p.exitValue(), (Object)results);
        return null;
    }
}

