/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.ui4j.spi;

import io.webfolder.ui4j.api.dom.EventTarget;
import io.webfolder.ui4j.api.event.EventHandler;
import io.webfolder.ui4j.spi.EventManager;
import io.webfolder.ui4j.spi.PageContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NativeEventManager
implements EventManager {
    private PageContext context;

    public NativeEventManager(PageContext context) {
        this.context = context;
    }

    @Override
    public void bind(EventTarget target, String event, EventHandler handler) {
        if (target != null) {
            this.context.getEventRegistrar().register(target, event, handler);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("event", event);
            map.put("listener", handler);
            ArrayList events = (ArrayList)target.getProperty("events");
            if (events == null || "undefined".equals(((Object)events).toString().trim())) {
                events = new ArrayList(1);
                target.setProperty("events", events);
            }
            events.add(map);
        }
    }

    @Override
    public void unbind(EventTarget target) {
        Object eventObject = target.getProperty("events");
        if (eventObject == null || "undefined".equals(eventObject.toString().trim())) {
            return;
        }
        if (List.class.isAssignableFrom(eventObject.getClass())) {
            List events = (List)eventObject;
            for (Map next : events) {
                String event = next.get("event").toString();
                EventHandler handler = (EventHandler)next.get("listener");
                this.context.getEventRegistrar().unregister(target, event, handler);
            }
            events.clear();
            target.removeProperty("events");
        }
    }

    @Override
    public void unbind(EventTarget target, String event) {
        Object eventObject = target.getProperty("events");
        if (eventObject == null || "undefined".equals(eventObject.toString().trim())) {
            return;
        }
        List events = (List)eventObject;
        ArrayList<Map> founds = new ArrayList<Map>();
        for (Map next : events) {
            String nextEvent = next.get("event").toString();
            if (!nextEvent.equals(event)) continue;
            founds.add(next);
            EventHandler handler = (EventHandler)next.get("listener");
            this.context.getEventRegistrar().unregister(target, nextEvent, handler);
        }
        events.removeAll(founds);
    }

    @Override
    public void unbind(EventTarget target, EventHandler handler) {
        Object eventObject = target.getProperty("events");
        if (eventObject == null || "undefined".equals(eventObject.toString().trim())) {
            return;
        }
        List events = (List)eventObject;
        Map found = Collections.emptyMap();
        for (Map next : events) {
            EventHandler nextHandler = (EventHandler)next.get("listener");
            if (!nextHandler.equals(handler)) continue;
            found = next;
            String nextEvent = next.get("event").toString();
            this.context.getEventRegistrar().unregister(target, nextEvent, handler);
        }
        events.remove(found);
    }
}

