/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.ui4j.api.interceptor;

import java.net.HttpCookie;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Request {
    private String url;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private URLConnection urlConnection;

    public Request(String url) {
        this.url = url;
    }

    public Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public Optional<String> getHeader(String name) {
        List<String> values = this.headers.get(name);
        if (values != null && !values.isEmpty()) {
            return Optional.of(values.get(0));
        }
        return Optional.empty();
    }

    public String getUrl() {
        return this.url;
    }

    public Request setHeader(String name, String ... values) {
        this.headers.put(name, Arrays.asList(values));
        return this;
    }

    public Request setCookie(HttpCookie cookie) {
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        cookies.add(cookie);
        this.setCookies(cookies);
        return this;
    }

    public boolean removeHeader(String name) {
        List<String> list = this.headers.remove(name);
        return list != null;
    }

    public boolean removeHeaders(List<String> names) {
        boolean removed = false;
        if (names != null) {
            for (String name : names) {
                removed &= this.removeHeader(name);
            }
        }
        return removed;
    }

    public List<HttpCookie> getCookies() {
        List<String> cookies = this.headers.get("Cookie");
        if (cookies == null || cookies.isEmpty()) {
            return Collections.emptyList();
        }
        String cookie = cookies.get(0);
        if (cookie == null || cookie.trim().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HttpCookie> list = new ArrayList<HttpCookie>();
        for (String next : cookie.split(";")) {
            list.addAll(HttpCookie.parse(next));
        }
        return list;
    }

    public boolean removeCookie(String name) {
        List<HttpCookie> cookies = this.getCookies();
        ArrayList<HttpCookie> newCookies = new ArrayList<HttpCookie>();
        if (name != null && !name.trim().isEmpty()) {
            for (HttpCookie cookie : cookies) {
                if (cookie.getName().equals(name)) continue;
                newCookies.add(cookie);
            }
        }
        this.setCookies(newCookies);
        return false;
    }

    public boolean removeCookies(List<String> names) {
        boolean removed = false;
        if (names != null) {
            for (String name : names) {
                removed &= this.removeCookie(name);
            }
        }
        return removed;
    }

    public Request setCookies(List<HttpCookie> cookies) {
        StringBuilder builder = new StringBuilder();
        for (HttpCookie cookie : cookies) {
            builder.append(cookie.getName()).append("=").append(cookie.getValue()).append(";");
        }
        this.setHeader("Cookie", builder.toString());
        return this;
    }

    public URLConnection getUrlConnection() {
        return this.urlConnection;
    }

    public void setUrlConnection(URLConnection urlConnection) {
        this.urlConnection = urlConnection;
    }

    public String toString() {
        return "Request [url=" + this.url + ", headers=" + this.headers + ", urlConnection=" + this.urlConnection + "]";
    }
}

