/*
 * Decompiled with CFR 0.152.
 */
package io.webfolder.ui4j.api.dom;

import io.webfolder.ui4j.api.dom.Element;
import java.util.List;
import java.util.Optional;

public class Form {
    private Element element;

    public Form(Element element) {
        this.element = element;
    }

    public void clear() {
        List<Element> inputs = this.element.find("input, select, textarea");
        for (Element next : inputs) {
            String tag = next.getTagName();
            if (tag.equals("input")) {
                Optional<String> attribute = next.getAttribute("type");
                if (attribute.isPresent()) {
                    String type = attribute.get().trim();
                    if (type.equalsIgnoreCase("radio")) {
                        next.getRadioButton().get().setChecked(false);
                        continue;
                    }
                    if (type.equalsIgnoreCase("checkbox")) {
                        next.getCheckBox().get().setChecked(false);
                        continue;
                    }
                    if (!type.equalsIgnoreCase("text")) continue;
                    next.setValue("");
                    continue;
                }
                next.setValue("");
                continue;
            }
            if (tag.equals("select")) {
                next.getSelect().get().clearSelection();
                continue;
            }
            if (!tag.equals("textarea")) continue;
            next.setText("");
        }
    }

    public Element getElement() {
        return this.element;
    }

    public void submit() {
        this.element.eval("this.submit()");
    }
}

