/*
 * Decompiled with CFR 0.152.
 */
package io.wavebeans.jupyter;

import io.wavebeans.execution.SingleThreadedOverseer;
import io.wavebeans.http.HttpService;
import io.wavebeans.jupyter.Config;
import io.wavebeans.jupyter.Evaluator;
import io.wavebeans.jupyter.LocalTableActivityTracker;
import io.wavebeans.jupyter.PreviewSampleBeanStream;
import io.wavebeans.lib.table.TableOutput;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\u0015\u001a\u00020\u000fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/wavebeans/jupyter/Evaluator;", "", "()V", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "httpService", "Lio/wavebeans/http/HttpService;", "log", "Lmu/KLogger;", "tableTrackTasks", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/concurrent/Future;", "evalTableOutput", "", "output", "Lio/wavebeans/lib/table/TableOutput;", "sampleRate", "", "getInitJsHtml", "initEnvironment", "jupyter-wave"})
public final class Evaluator {
    private static final KLogger log;
    private static HttpService httpService;
    private static final ScheduledExecutorService executor;
    private static final ConcurrentHashMap<String, Future<?>> tableTrackTasks;
    public static final Evaluator INSTANCE;

    public final void initEnvironment() {
        Config.Companion.getInstance().readEnv();
    }

    public final void evalTableOutput(@NotNull TableOutput<?> output, float sampleRate) {
        Intrinsics.checkNotNullParameter(output, (String)"output");
        log.info((Function0)new Function0<Object>(output, sampleRate){
            final /* synthetic */ TableOutput $output;
            final /* synthetic */ float $sampleRate;

            @Nullable
            public final Object invoke() {
                return "Evaluating output " + this.$output + " with sample rate " + this.$sampleRate;
            }
            {
                this.$output = tableOutput;
                this.$sampleRate = f;
                super(0);
            }
        });
        SingleThreadedOverseer overseer = new SingleThreadedOverseer(CollectionsKt.listOf(output));
        List evalFuture = overseer.eval(sampleRate);
        String tableName = output.getParameters().getTableName();
        LocalTableActivityTracker tracker = LocalTableActivityTracker.Companion.createAndRegister(tableName);
        Future<?> future = tableTrackTasks.get(tableName);
        if (future != null) {
            future.cancel(true);
        }
        Map map = tableTrackTasks;
        ScheduledFuture<?> scheduledFuture = executor.scheduleWithFixedDelay(new Runnable(tracker, tableName, evalFuture, overseer){
            final /* synthetic */ LocalTableActivityTracker $tracker;
            final /* synthetic */ String $tableName;
            final /* synthetic */ List $evalFuture;
            final /* synthetic */ SingleThreadedOverseer $overseer;

            public final void run() {
                block5: {
                    try {
                        if (!this.$tracker.isStillActive()) {
                            Evaluator.access$getLog$p(Evaluator.INSTANCE).info((Function0)new Function0<Object>(this){
                                final /* synthetic */ evalTableOutput.2 this$0;

                                @Nullable
                                public final Object invoke() {
                                    return "Table " + this.this$0.$tableName + " is not active anymore";
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            });
                            Iterable $this$forEach$iv = this.$evalFuture;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                Future it = (Future)element$iv;
                                boolean bl = false;
                                if (it.isDone()) continue;
                                it.cancel(true);
                            }
                            this.$overseer.close();
                            Future future = (Future)Evaluator.access$getTableTrackTasks$p(Evaluator.INSTANCE).remove(this.$tableName);
                            if (future != null) {
                                future.cancel(false);
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (e instanceof CancellationException) break block5;
                        Evaluator.access$getLog$p(Evaluator.INSTANCE).error(e, (Function0)new Function0<Object>(this){
                            final /* synthetic */ evalTableOutput.2 this$0;

                            @Nullable
                            public final Object invoke() {
                                return "Exception working with tracker for table " + this.this$0.$tableName;
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                }
            }
            {
                this.$tracker = localTableActivityTracker;
                this.$tableName = string;
                this.$evalFuture = list;
                this.$overseer = singleThreadedOverseer;
            }
        }, 0L, 5000L, TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"executor.scheduleWithFix\u2026}, 0, 5000, MILLISECONDS)");
        map.put(tableName, scheduledFuture);
    }

    @NotNull
    public final String getInitJsHtml() {
        return PreviewSampleBeanStream.Companion.getInitHtml();
    }

    private Evaluator() {
    }

    static {
        Evaluator evaluator;
        INSTANCE = evaluator = new Evaluator();
        log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);
        executor = Executors.newScheduledThreadPool(1);
        tableTrackTasks = new ConcurrentHashMap();
        Config.Companion.getInstance().watch(Config.Companion.getHttpPortVar(), (Function1<? super String, Unit>)((Function1)1.INSTANCE));
        Config.Companion.getInstance().watch(Config.Companion.getDropboxAccessTokenVar(), (Function1<? super String, Unit>)((Function1)2.INSTANCE));
    }

    public static final /* synthetic */ KLogger access$getLog$p(Evaluator $this) {
        Evaluator evaluator = $this;
        return log;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getTableTrackTasks$p(Evaluator $this) {
        Evaluator evaluator = $this;
        return tableTrackTasks;
    }

    public static final /* synthetic */ HttpService access$getHttpService$p(Evaluator $this) {
        Evaluator evaluator = $this;
        return httpService;
    }

    public static final /* synthetic */ void access$setHttpService$p(Evaluator $this, HttpService httpService) {
        Evaluator evaluator = $this;
        Evaluator.httpService = httpService;
    }
}

