/*
 * Decompiled with CFR 0.152.
 */
package io.wavebeans.jupyter;

import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import io.wavebeans.jupyter.Config;
import io.wavebeans.jupyter.EvaluatorKt;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 $2\u00020\u0001:\u0001$B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u0006\u0010\u001f\u001a\u00020\u001bJ\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00042\b\u0010!\u001a\u0004\u0018\u00010\u0004J$\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00042\u0014\u0010#\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u001b0\u0003R\u0011\u0010\u0006\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0019\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u001b0\u00030\u001a0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/wavebeans/jupyter/Config;", "Ljava/io/Closeable;", "getenv", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)V", "advertisedHost", "getAdvertisedHost", "()Ljava/lang/String;", "advertisedPort", "", "getAdvertisedPort", "()Ljava/lang/Integer;", "advertisedProtocol", "getAdvertisedProtocol", "config", "Ljava/util/concurrent/ConcurrentHashMap;", "dropBoxAccessToken", "getDropBoxAccessToken", "dropBoxClientIdentifier", "getDropBoxClientIdentifier", "httpPort", "getHttpPort", "managementServer", "Lio/javalin/Javalin;", "watchers", "", "", "close", "get", "name", "readEnv", "set", "value", "watch", "watcher", "Companion", "jupyter-wave"})
public final class Config
implements Closeable {
    private final ConcurrentHashMap<String, String> config;
    private final ConcurrentHashMap<String, List<Function1<String, Unit>>> watchers;
    private final Javalin managementServer;
    private final Function1<String, String> getenv;
    @NotNull
    private static final Config instance;
    @NotNull
    private static final String advertisedHostVar;
    @NotNull
    private static final String advertisedPortVar;
    @NotNull
    private static final String advertisedProtocolVar;
    @NotNull
    private static final String httpPortVar;
    @NotNull
    private static final String dropBoxClientIdentifierVar;
    @NotNull
    private static final String dropboxAccessTokenVar;
    private static final KLogger log;
    public static final Companion Companion;

    @NotNull
    public final String getAdvertisedHost() {
        String string = this.config.get(advertisedHostVar);
        if (string == null) {
            string = "localhost";
        }
        return string;
    }

    @Nullable
    public final Integer getAdvertisedPort() {
        Integer n;
        String string = this.config.get(advertisedPortVar);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            n = Integer.parseInt(string2);
        } else {
            n = this.getHttpPort();
        }
        return n;
    }

    @NotNull
    public final String getAdvertisedProtocol() {
        String string = this.config.get(advertisedProtocolVar);
        if (string == null) {
            string = "http";
        }
        return string;
    }

    @Nullable
    public final Integer getHttpPort() {
        Integer n;
        String string = this.config.get(httpPortVar);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            n = Integer.parseInt(string2);
        } else {
            n = null;
        }
        return n;
    }

    @Nullable
    public final String getDropBoxClientIdentifier() {
        return this.config.get(dropBoxClientIdentifierVar);
    }

    @Nullable
    public final String getDropBoxAccessToken() {
        return this.config.get(dropboxAccessTokenVar);
    }

    @Nullable
    public final String get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.config.get(name);
    }

    public final void set(@NotNull String name, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            if (value != null) {
                ((Map)this.config).put(name, value);
            } else {
                this.config.remove(name);
            }
            List<Function1<String, Unit>> list = this.watchers.get(name);
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function1 watcher = (Function1)element$iv;
                    boolean bl = false;
                    try {
                        watcher.invoke((Object)value);
                    }
                    catch (Exception e) {
                        log.error((Throwable)e, (Function0)new Function0<Object>(watcher, value){
                            final /* synthetic */ Function1 $watcher;
                            final /* synthetic */ String $value$inlined;
                            {
                                this.$watcher = function1;
                                this.$value$inlined = string;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                return "Error with watcher `" + this.$watcher + "` handling value `" + this.$value$inlined + '`';
                            }
                        });
                    }
                }
            }
        }
        catch (Exception e) {
            throw (Throwable)new IllegalStateException("Can't set value `" + value + "` for variable `" + name + '`', e);
        }
    }

    public final void watch(@NotNull String name, @NotNull Function1<? super String, Unit> watcher) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(watcher, (String)"watcher");
        this.watchers.computeIfAbsent(name, watch.1.INSTANCE);
        ((List)MapsKt.getValue((Map)this.watchers, (Object)name)).add(watcher);
    }

    public final void readEnv() {
        this.set(advertisedHostVar, EvaluatorKt.getEnvVar(advertisedHostVar, this.getenv));
        this.set(advertisedPortVar, EvaluatorKt.getEnvVar(advertisedPortVar, this.getenv));
        this.set(advertisedProtocolVar, EvaluatorKt.getEnvVar(advertisedProtocolVar, this.getenv));
        this.set(httpPortVar, EvaluatorKt.getEnvVar(httpPortVar, this.getenv));
        this.set(dropBoxClientIdentifierVar, EvaluatorKt.getEnvVar(dropBoxClientIdentifierVar, this.getenv));
        this.set(dropboxAccessTokenVar, EvaluatorKt.getEnvVar(dropboxAccessTokenVar, this.getenv));
    }

    @Override
    public void close() {
        block0: {
            Javalin javalin = this.managementServer;
            if (javalin == null) break block0;
            javalin.stop();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Config(@NotNull Function1<? super String, String> getenv) {
        block3: {
            Javalin javalin;
            Intrinsics.checkNotNullParameter(getenv, (String)"getenv");
            this.getenv = getenv;
            this.config = new ConcurrentHashMap();
            this.watchers = new ConcurrentHashMap();
            Config config = this;
            String string = EvaluatorKt.getEnvVar("MANAGEMENT_SERVER_PORT", this.getenv);
            if (string != null) {
                void it;
                String string2 = string;
                boolean bl = false;
                int n = Integer.parseInt(string2);
                bl = false;
                boolean bl2 = false;
                int n2 = n;
                Config config2 = config;
                boolean bl3 = false;
                Javalin javalin2 = Javalin.create().start((int)it);
                config = config2;
                javalin = javalin2;
            } else {
                javalin = null;
            }
            config.managementServer = javalin;
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public final void run() {
                    this.close();
                }
            }));
            Javalin javalin3 = this.managementServer;
            if (javalin3 != null) {
                javalin3.post("/config/:name", new Handler(){

                    public final void handle(@NotNull Context ctx) {
                        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                        String name = ctx.pathParam("name");
                        this.set(name, ctx.body());
                        ctx.status(200);
                    }
                });
            }
            Javalin javalin4 = this.managementServer;
            if (javalin4 == null) break block3;
            javalin4.get("/config/:name", new Handler(){

                public final void handle(@NotNull Context ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    String name = ctx.pathParam("name");
                    String value = this.get(name);
                    if (value != null) {
                        ctx.result(value);
                    } else {
                        ctx.status(404);
                    }
                }
            });
        }
    }

    static {
        Companion = new Companion(null);
        instance = new Config((Function1<? super String, String>)((Function1)Companion.instance.1.INSTANCE));
        advertisedHostVar = "ADVERTISED_HTTP_HOST";
        advertisedPortVar = "ADVERTISED_HTTP_PORT";
        advertisedProtocolVar = "ADVERTISED_HTTP_PROTOCOL";
        httpPortVar = "HTTP_PORT";
        dropBoxClientIdentifierVar = "DROPBOX_CLIENT_IDENTIFIER";
        dropboxAccessTokenVar = "DROPBOX_ACCESS_TOKEN";
        log = KotlinLogging.INSTANCE.logger((Function0)Companion.log.1.INSTANCE);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/wavebeans/jupyter/Config$Companion;", "", "()V", "advertisedHostVar", "", "getAdvertisedHostVar", "()Ljava/lang/String;", "advertisedPortVar", "getAdvertisedPortVar", "advertisedProtocolVar", "getAdvertisedProtocolVar", "dropBoxClientIdentifierVar", "getDropBoxClientIdentifierVar", "dropboxAccessTokenVar", "getDropboxAccessTokenVar", "httpPortVar", "getHttpPortVar", "instance", "Lio/wavebeans/jupyter/Config;", "getInstance", "()Lio/wavebeans/jupyter/Config;", "log", "Lmu/KLogger;", "jupyter-wave"})
    public static final class Companion {
        @NotNull
        public final Config getInstance() {
            return instance;
        }

        @NotNull
        public final String getAdvertisedHostVar() {
            return advertisedHostVar;
        }

        @NotNull
        public final String getAdvertisedPortVar() {
            return advertisedPortVar;
        }

        @NotNull
        public final String getAdvertisedProtocolVar() {
            return advertisedProtocolVar;
        }

        @NotNull
        public final String getHttpPortVar() {
            return httpPortVar;
        }

        @NotNull
        public final String getDropBoxClientIdentifierVar() {
            return dropBoxClientIdentifierVar;
        }

        @NotNull
        public final String getDropboxAccessTokenVar() {
            return dropboxAccessTokenVar;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

