/*
 * Decompiled with CFR 0.152.
 */
package io.vtom.vertx.pipeline.component.db.sql.psql;

import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.enoa.toolkit.text.TextKit;
import io.vtom.vertx.pipeline.component.db.sql.psql.IPSql;
import io.vtom.vertx.pipeline.component.db.sql.psql.PSql;
import io.vtom.vertx.pipeline.component.db.thr.VtomSqlException;
import java.util.regex.Pattern;

class _DefaultPSqlBuilder {
    private static final int START = "select ".length();

    private _DefaultPSqlBuilder() {
    }

    public static _DefaultPSqlBuilder instance() {
        return Holder.INSTANCE;
    }

    private static String rmEndSymbol(String sql) {
        sql = Holder.ORDER_BY_PATTERN.matcher(sql).replaceAll("");
        return TextKit.removeRightChar((String)sql, (char)';');
    }

    private static int fix(String sql) {
        int parenDepth = 0;
        int end = sql.length() - 5;
        for (int i = START; i < end; ++i) {
            char c = sql.charAt(i);
            if (c >= '\u0080' || (c = Holder.CHAR_TABLE[c]) == '\u0000') continue;
            if (c == '(') {
                ++parenDepth;
                continue;
            }
            if (c == ')') {
                if (parenDepth == 0) {
                    throw new RuntimeException("Can not match left paren '(' for right paren ')': " + sql);
                }
                --parenDepth;
                continue;
            }
            if (parenDepth > 0 || c != 'f' || Holder.CHAR_TABLE[sql.charAt(i + 1)] != 'r' || Holder.CHAR_TABLE[sql.charAt(i + 2)] != 'o' || Holder.CHAR_TABLE[sql.charAt(i + 3)] != 'm') continue;
            c = sql.charAt(i + 4);
            if (Holder.CHAR_TABLE[c] != ' ' && c != '(') continue;
            c = sql.charAt(i - 1);
            if (Holder.CHAR_TABLE[c] != ' ' && c != ')') continue;
            return i;
        }
        return -1;
    }

    IPSql subquery() {
        return Holder.SUBQUERY;
    }

    IPSql sqlfrom() {
        return Holder.SQLFROM;
    }

    private static class Holder {
        private static final _DefaultPSqlBuilder INSTANCE = new _DefaultPSqlBuilder();
        private static final Pattern ORDER_BY_PATTERN = Pattern.compile("order\\s+by\\s+[^,\\s]+(\\s+asc|\\s+desc)?(\\s*,\\s*[^,\\s]+(\\s+asc|\\s+desc)?)*", 10);
        private static char[] CHAR_TABLE = Holder.buildCharTable();
        private static final IPSql SUBQUERY = sql -> {
            String _sql0 = _DefaultPSqlBuilder.rmEndSymbol(sql);
            String _sql1 = TextKit.union((String)"select count(1) from (", (Object[])new Object[]{_sql0, ") as t"});
            return PSql.create(_sql1, sql);
        };
        private static final IPSql SQLFROM = sql -> {
            String _sql0 = _DefaultPSqlBuilder.rmEndSymbol(sql);
            int fix = _DefaultPSqlBuilder.fix(_sql0);
            if (fix == -1) {
                throw new VtomSqlException(EnoaTipKit.message((String)"eo.tip.vtom.db.sql_illegal", (Object[])new Object[]{sql}), new Object[0]);
            }
            String _from = _sql0.substring(fix);
            _from = ORDER_BY_PATTERN.matcher(_from).replaceAll("");
            String _sql1 = TextKit.union((String)"select count(1) ", (Object[])new Object[]{_from});
            return PSql.create(_sql1, sql);
        };

        private Holder() {
        }

        private static char[] buildCharTable() {
            char[] ret = new char[128];
            int i = 128;
            while (true) {
                int n = i;
                i = (char)(i - 1);
                if (n <= 0) break;
                ret[i] = '\u0000';
            }
            ret[40] = 40;
            ret[41] = 41;
            ret[102] = 102;
            ret[70] = 102;
            ret[114] = 114;
            ret[82] = 114;
            ret[111] = 111;
            ret[79] = 111;
            ret[109] = 109;
            ret[77] = 109;
            ret[32] = 32;
            ret[13] = 32;
            ret[10] = 32;
            ret[9] = 32;
            return ret;
        }
    }
}

