/*
 * Decompiled with CFR 0.152.
 */
package io.vtom.vertx.pipeline.component.db.data;

import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.convert.IConverter;
import io.enoa.toolkit.eo.tip.EnoaTipKit;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.sql.ResultSet;
import io.vtom.vertx.pipeline.component.db.data.Row;
import io.vtom.vertx.pipeline.component.db.data.Table;
import io.vtom.vertx.pipeline.component.db.page.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DBConverter {
    private static <T> void checkType(T origin, Class clazz) {
        if (clazz != origin.getClass()) {
            throw new IllegalArgumentException(EnoaTipKit.message((String)"eo.tip.vtom.db.convert_origin_type_error", (Object[])new Object[]{clazz, origin.getClass()}));
        }
    }

    public static <T> IConverter<Table, T> toTable() {
        return origin -> {
            if (origin == null) {
                return null;
            }
            DBConverter.checkType(origin, ResultSet.class);
            return new Table((ResultSet)origin);
        };
    }

    public static <T> IConverter<List<Row>, T> toRows() {
        return origin -> {
            if (origin == null) {
                return Collections.emptyList();
            }
            DBConverter.checkType(origin, ResultSet.class);
            ResultSet rs = (ResultSet)origin;
            return rs.getRows().stream().map(Row::create).collect(Collectors.toList());
        };
    }

    public static <T> IConverter<Row, T> toRow() {
        return origin -> {
            IConverter converter = DBConverter.toRows();
            List rows = (List)converter.convert(origin);
            return CollectionKit.isEmpty((Collection)rows) != false ? null : (Row)rows.get(0);
        };
    }

    public static <T> IConverter<Page<Row>, T> toPageRow() {
        return origin -> {
            if (origin == null) {
                return null;
            }
            DBConverter.checkType(origin, Page.class);
            Page po = (Page)origin;
            List rows0 = po.getRows();
            if (CollectionKit.isEmpty(rows0).booleanValue()) {
                return po;
            }
            ArrayList<Row> rows1 = new ArrayList<Row>(rows0.size());
            for (Object o1 : rows0) {
                if (o1 instanceof Row) {
                    rows1.add((Row)o1);
                    continue;
                }
                if (!(o1 instanceof JsonObject)) {
                    throw new IllegalArgumentException(EnoaTipKit.message((String)"eo.tip.vtom.db.convert_origin_type_error", (Object[])new Object[]{JsonObject.class, o1.getClass()}));
                }
                rows1.add(Row.create((JsonObject)o1));
            }
            po.setRows(rows1);
            CollectionKit.clear((Collection[])new Collection[]{rows0});
            return po;
        };
    }
}

