/*
 * Decompiled with CFR 0.152.
 */
package io.vtom.vertx.pipeline.component.db;

import io.enoa.toolkit.collection.CollectionKit;
import io.enoa.toolkit.map.Kv;
import io.enoa.toolkit.number.NumberKit;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.UpdateResult;
import io.vtom.vertx.pipeline.PipeRunnable;
import io.vtom.vertx.pipeline.component.db.page.Page;
import io.vtom.vertx.pipeline.component.db.sql.TSql;
import io.vtom.vertx.pipeline.component.db.sql.VTSout;
import io.vtom.vertx.pipeline.component.db.sql.psql.IPSql;
import io.vtom.vertx.pipeline.component.db.sql.psql.PSql;
import io.vtom.vertx.pipeline.component.db.sql.reporter.ISqlReporter;
import io.vtom.vertx.pipeline.step.Step;
import io.vtom.vertx.pipeline.tk.Pvtk;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class VtomDBPipeRunnable
implements PipeRunnable<TSql, VTSout> {
    private JDBCClient client;
    private Step<? extends TSql> step;
    private Kv shared;

    VtomDBPipeRunnable(JDBCClient client, Step<? extends TSql> step, Kv shared) {
        this.client = client;
        this.step = step;
        this.shared = shared;
    }

    public Step<? extends TSql> step() {
        return this.step;
    }

    public void call(VTSout stepout, Handler<AsyncResult<Object>> handler) {
        SQLConnection holderconn = (SQLConnection)this.shared.as("conn");
        if (holderconn != null) {
            try {
                this.vrun2(holderconn, stepout, handler);
            }
            catch (Exception e) {
                handler.handle((Object)Future.failedFuture((Throwable)e));
            }
            return;
        }
        this.client.getConnection(ar -> {
            if (ar.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                return;
            }
            SQLConnection conn = (SQLConnection)ar.result();
            this.shared.set("conn", (Object)conn);
            Boolean tx = this.shared.bool("tx", Boolean.FALSE);
            if (!tx.booleanValue()) {
                try {
                    this.vrun2(conn, stepout, handler);
                }
                catch (Exception e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                }
                return;
            }
            conn.setAutoCommit(false, acr -> {
                if (acr.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)acr.cause()));
                    return;
                }
                try {
                    this.vrun2(conn, stepout, handler);
                }
                catch (Exception e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                }
            });
        });
    }

    public void release(boolean ok, Handler<AsyncResult<Void>> handler) {
        AtomicInteger arc = (AtomicInteger)this.shared.as("arc");
        if (arc == null || arc.decrementAndGet() != 0) {
            handler.handle((Object)Future.succeededFuture());
            return;
        }
        SQLConnection conn = (SQLConnection)this.shared.as("conn");
        if (conn == null) {
            CollectionKit.clear((Map[])new Map[]{this.shared});
            handler.handle((Object)Future.succeededFuture());
            return;
        }
        Boolean tx = this.shared.bool("tx", Boolean.FALSE);
        if (!tx.booleanValue()) {
            conn.close();
            CollectionKit.clear((Map[])new Map[]{this.shared});
            handler.handle((Object)Future.succeededFuture());
            return;
        }
        Boolean txCanceled = this.shared.bool("tx_canceled", Boolean.FALSE);
        if (txCanceled.booleanValue()) {
            CollectionKit.clear((Map[])new Map[]{this.shared});
            handler.handle((Object)Future.succeededFuture());
            return;
        }
        this.shared.set("tx_canceled", (Object)Boolean.TRUE);
        if (ok) {
            conn.commit(handler);
            CollectionKit.clear((Map[])new Map[]{this.shared});
            return;
        }
        conn.rollback(handler);
        CollectionKit.clear((Map[])new Map[]{this.shared});
    }

    private void vrun2(SQLConnection conn, VTSout output, Handler<AsyncResult<Object>> handler) {
        String sql = output.sql();
        JsonArray paras = output.paras();
        String reportmark = this.reportMark(output);
        switch (output.action()) {
            case CALL: {
                break;
            }
            case UPDATE: {
                this.reportSql(output, reportmark, sql, paras);
                conn.updateWithParams(sql, paras, ar -> {
                    if (ar.failed()) {
                        handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                        return;
                    }
                    UpdateResult result = (UpdateResult)ar.result();
                    handler.handle((Object)Future.succeededFuture((Object)result));
                });
                break;
            }
            case SELECT: {
                if (!output.pageSelect()) {
                    this.reportSql(output, reportmark, sql, paras);
                    conn.queryWithParams(sql, paras, Pvtk.handleTo(handler));
                    return;
                }
                IPSql ipsql = output.ipsql();
                PSql psql = ipsql.psql(sql);
                int ps = output.ps() < 1 ? 1 : output.ps();
                int pn = output.pn() < 1 ? 1 : output.pn();
                this.reportSql(output, reportmark, psql.countSql(), paras);
                conn.queryWithParams(psql.countSql(), paras, ar0 -> {
                    if (ar0.failed()) {
                        handler.handle((Object)Future.failedFuture((Throwable)ar0.cause()));
                        return;
                    }
                    ResultSet countresult = (ResultSet)ar0.result();
                    Integer _rows = ((JsonArray)countresult.getResults().get(0)).getInteger(0);
                    if (_rows == 0) {
                        Page page = new Page(pn, ps, 0, 0L, 0L, Collections.emptyList(), Collections.emptyList());
                        handler.handle((Object)Future.succeededFuture(page));
                        return;
                    }
                    int _totalPage = NumberKit.integer((Number)(_rows / ps));
                    if (_rows % ps != 0) {
                        ++_totalPage;
                    }
                    int tpg = _totalPage;
                    long offset = ps * (pn - 1);
                    if (pn > tpg) {
                        Page page = new Page(pn, ps, tpg, offset, _rows.intValue(), Collections.emptyList(), Collections.emptyList());
                        handler.handle((Object)Future.succeededFuture(page));
                        return;
                    }
                    String pageSql = output.dialect().pageSql(offset, ps, psql.selectSql());
                    this.reportSql(output, reportmark, pageSql, paras);
                    conn.queryWithParams(pageSql, paras, ar1 -> {
                        if (ar1.failed()) {
                            handler.handle((Object)Future.failedFuture((Throwable)ar1.cause()));
                            return;
                        }
                        ResultSet presult = (ResultSet)ar1.result();
                        Page page = new Page(pn, ps, tpg, offset, _rows.intValue(), presult.getColumnNames(), presult.getRows());
                        handler.handle((Object)Future.succeededFuture(page));
                    });
                });
            }
        }
    }

    private String reportMark(VTSout output) {
        if (!output.showSql()) {
            return null;
        }
        ISqlReporter reporter = output.reporter();
        if (reporter == null) {
            return null;
        }
        return reporter.mark();
    }

    private void reportSql(VTSout output, String mark, String sql, JsonArray paras) {
        if (!output.showSql()) {
            return;
        }
        ISqlReporter reporter = output.reporter();
        if (reporter == null) {
            return;
        }
        reporter.report(mark, sql, paras);
    }
}

