/*
 * Decompiled with CFR 0.152.
 */
package io.vtom.vertx.pipeline.component.db.sql.template;

import io.enoa.firetpl.FireBody;
import io.enoa.toolkit.map.Kv;
import io.vertx.core.json.JsonArray;
import io.vtom.vertx.pipeline.component.db.dialect.IDialect;
import io.vtom.vertx.pipeline.component.db.sql.AbstractTSql;
import io.vtom.vertx.pipeline.component.db.sql.AbstractVTSout;
import io.vtom.vertx.pipeline.component.db.sql.SqlAction;
import io.vtom.vertx.pipeline.component.db.sql.TSql;
import io.vtom.vertx.pipeline.component.db.sql.TSqlOptions;
import io.vtom.vertx.pipeline.component.db.sql.VTSout;
import io.vtom.vertx.pipeline.component.db.sql.psql.IPSql;
import io.vtom.vertx.pipeline.component.db.sql.reporter.ISqlReporter;
import java.util.Map;

public class VtmTplSql
extends AbstractTSql<VtmTplSql> {
    private TSqlOptions options;
    private SqlAction action;
    private String sqlname;
    private Kv parakv;
    private IPSql ipsql;
    private int ps;
    private int pn;
    private boolean pageSelect;

    private VtmTplSql(String cfgname) {
        this.options = TSql.epm().options(cfgname);
    }

    static VtmTplSql with(String cfgname) {
        return new VtmTplSql(cfgname);
    }

    VtmTplSql action(SqlAction action) {
        this.action = action;
        return this;
    }

    VtmTplSql sqlname(String sqlname) {
        this.sqlname = sqlname;
        return this;
    }

    VtmTplSql ipsql(IPSql ipsql) {
        this.ipsql = ipsql;
        return this;
    }

    VtmTplSql ps(int ps) {
        this.ps = ps;
        return this;
    }

    VtmTplSql pn(int pn) {
        this.pn = pn;
        return this;
    }

    VtmTplSql pageSelect() {
        return this.pageSelect(Boolean.TRUE);
    }

    VtmTplSql pageSelect(boolean pageSelect) {
        this.pageSelect = pageSelect;
        return this;
    }

    public VtmTplSql para(Kv kv) {
        this.parakv = kv;
        return this;
    }

    @Override
    public VTSout out() {
        final FireBody firebody = this.options.getFiretpl().render(this.sqlname, (Map)this.parakv);
        Object[] fireparas = firebody.paras();
        JsonArray paja = super.paras();
        if (paja == null) {
            paja = new JsonArray();
            for (Object firepara : fireparas) {
                if (firepara == null) {
                    paja.addNull();
                    continue;
                }
                paja.add(firepara);
            }
        }
        final JsonArray _paras = paja;
        return new AbstractVTSout(this.stepskips()){

            @Override
            public IDialect dialect() {
                return VtmTplSql.this.options.getDialect();
            }

            @Override
            public SqlAction action() {
                return VtmTplSql.this.action;
            }

            @Override
            public String sql() {
                return firebody.tpl();
            }

            @Override
            public JsonArray paras() {
                return _paras;
            }

            @Override
            public boolean showSql() {
                return VtmTplSql.this.options.isShowSql();
            }

            @Override
            public ISqlReporter reporter() {
                return VtmTplSql.this.options.getReporter();
            }

            @Override
            public boolean pageSelect() {
                return VtmTplSql.this.pageSelect;
            }

            @Override
            public IPSql ipsql() {
                return VtmTplSql.this.ipsql;
            }

            @Override
            public int ps() {
                return VtmTplSql.this.ps;
            }

            @Override
            public int pn() {
                return VtmTplSql.this.pn;
            }
        };
    }
}

