/*
 * Decompiled with CFR 0.152.
 */
package io.vtom.vertx.pipeline.component.db.dialect;

import io.vtom.vertx.pipeline.component.db.dialect.IDialect;

public class SqlServerDialect
implements IDialect {
    private static final String[] KEYWORDS = new String[]{"select", "update", "insert", "delete", "where", "order", "by", "asc", "desc", "primary", "key", "index", "create", "function", "table", "database", "group", "having", "limit", "int", "bool", "serialize", "varchar", "char", "bytea"};

    @Override
    public String identifierQuoteStringLeft() {
        return "[";
    }

    @Override
    public String identifierQuoteStringRight() {
        return "]";
    }

    @Override
    public String[] keywords() {
        return KEYWORDS;
    }

    @Override
    public String pageSql(long offset, int size, String psql) {
        long limit = offset + (long)size;
        psql = psql.replaceFirst("(?i)select(\\s+distinct\\s+)?", "$0 top(" + limit + ") ");
        StringBuilder builder = new StringBuilder();
        builder.append("with query as (\n");
        builder.append("  select inq.*, row_number() over (order by current_timestamp) as rn from (\n");
        builder.append("   ").append(psql);
        builder.append("  ) as inq\n");
        builder.append(") select * from query where rn between ");
        builder.append(offset + 1L).append(" and ").append(limit);
        String sql = builder.toString();
        builder.delete(0, builder.length());
        return sql;
    }
}

