/*
 * Decompiled with CFR 0.152.
 */
package io.vpv.saml.metadata.util;

import io.vpv.saml.metadata.xml.modal.EntityDescriptorType;
import java.io.InputStream;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Unmarshaller;
import org.w3c.dom.Node;

public class XMLParser {
    public static String getAttributeValue(Node node, String attributeName) {
        String response = null;
        if (Objects.nonNull(node) && Objects.nonNull(node.getAttributes()) && Objects.nonNull(node.getAttributes().getNamedItem(attributeName))) {
            response = node.getAttributes().getNamedItem(attributeName).getNodeValue();
        }
        return response;
    }

    public static String stripNameSpace(String nodeName) {
        int index = nodeName.indexOf(":");
        if (index >= 0) {
            return nodeName.substring(index + 1);
        }
        return nodeName;
    }

    public static String getXPath(Node node) {
        Node parent = node.getParentNode();
        if (parent == null) {
            return node.getNodeName();
        }
        return XMLParser.getXPath(parent) + "/" + node.getNodeName();
    }

    public static EntityDescriptorType parseXML(InputStream inputStream) {
        EntityDescriptorType referenceList = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{EntityDescriptorType.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            referenceList = (EntityDescriptorType)JAXBIntrospector.getValue((Object)unmarshaller.unmarshal(inputStream));
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return referenceList;
    }
}

