/*
 * Decompiled with CFR 0.152.
 */
package io.vpv.saml.metadata.service;

import io.vpv.saml.metadata.model.ApplicationServiceEndpoint;
import io.vpv.saml.metadata.model.AssertionConsumerService;
import io.vpv.saml.metadata.model.CanonicalizationMethod;
import io.vpv.saml.metadata.model.ClaimType;
import io.vpv.saml.metadata.model.ClaimTypesOffered;
import io.vpv.saml.metadata.model.ContactPerson;
import io.vpv.saml.metadata.model.DigestMethod;
import io.vpv.saml.metadata.model.EndpointReference;
import io.vpv.saml.metadata.model.IDPMetaData;
import io.vpv.saml.metadata.model.IDPSSODescriptor;
import io.vpv.saml.metadata.model.KeyDescriptor;
import io.vpv.saml.metadata.model.KeyInfo;
import io.vpv.saml.metadata.model.Organization;
import io.vpv.saml.metadata.model.OrganizationDisplayName;
import io.vpv.saml.metadata.model.OrganizationName;
import io.vpv.saml.metadata.model.OrganizationURL;
import io.vpv.saml.metadata.model.PassiveRequestorEndpoint;
import io.vpv.saml.metadata.model.Reference;
import io.vpv.saml.metadata.model.RoleDescriptor;
import io.vpv.saml.metadata.model.SPMetaData;
import io.vpv.saml.metadata.model.SPSSODescriptor;
import io.vpv.saml.metadata.model.SecurityTokenServiceEndpoint;
import io.vpv.saml.metadata.model.Signature;
import io.vpv.saml.metadata.model.SignatureMethod;
import io.vpv.saml.metadata.model.SignedInfo;
import io.vpv.saml.metadata.model.SingleLogoutService;
import io.vpv.saml.metadata.model.SingleSignOnService;
import io.vpv.saml.metadata.model.TargetScopes;
import io.vpv.saml.metadata.model.Transform;
import io.vpv.saml.metadata.model.Transforms;
import io.vpv.saml.metadata.model.X509Data;
import io.vpv.saml.metadata.service.MetaDataParser;
import io.vpv.saml.metadata.util.XMLParser;
import io.vpv.saml.metadata.xml.modal.EntityDescriptorType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MetaDataParserImpl
implements MetaDataParser {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    @Override
    public SPMetaData parseSPMetadata(InputStream xml) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document xmlDocument = dBuilder.parse(xml);
            SPMetaData spMetaData = SPMetaData.builder().entityID(XMLParser.getAttributeValue(xmlDocument.getFirstChild(), "entityID")).validUntil(XMLParser.getAttributeValue(xmlDocument.getFirstChild(), "validUntil")).cacheDuration(XMLParser.getAttributeValue(xmlDocument.getFirstChild(), "cacheDuration")).iD(XMLParser.getAttributeValue(xmlDocument.getFirstChild(), "ID")).contactPerson(new ArrayList<ContactPerson>()).build();
            block14: for (int i = 0; i < xmlDocument.getFirstChild().getChildNodes().getLength(); ++i) {
                String nodeName;
                Node child = xmlDocument.getFirstChild().getChildNodes().item(i);
                switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                    case "Signature": {
                        spMetaData.setSignature(this.getSignatureInstance(child));
                        continue block14;
                    }
                    case "SPSSODescriptor": {
                        spMetaData.setSPSSODescriptor(this.getSPSSODescriptor(child));
                        continue block14;
                    }
                    case "Organization": {
                        spMetaData.setOrganization(this.getOrganization(child));
                        continue block14;
                    }
                    case "ContactPerson": {
                        spMetaData.getContactPerson().add(this.getContactPerson(child));
                        continue block14;
                    }
                    default: {
                        this.logNode(child);
                    }
                }
            }
            return spMetaData;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.LOGGER.error("Unable ot parse the document due to error", (Throwable)e);
            throw new RuntimeException("Unable ot parse the document due to error", e);
        }
    }

    private ContactPerson getContactPerson(Node contactPersonNode) {
        ContactPerson contactPerson = ContactPerson.builder().contactType(XMLParser.getAttributeValue(contactPersonNode, "contactType")).build();
        block8: for (int i = 0; i < contactPersonNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = contactPersonNode.getChildNodes().item(i);
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "GivenName": {
                    contactPerson.setGivenName(child.getTextContent());
                    continue block8;
                }
                case "EmailAddress": {
                    contactPerson.setEmailAddress(child.getTextContent());
                    continue block8;
                }
                default: {
                    this.logNode(child);
                }
            }
        }
        return contactPerson;
    }

    private Organization getOrganization(Node organizationNode) {
        Organization organization = Organization.builder().build();
        block10: for (int i = 0; i < organizationNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = organizationNode.getChildNodes().item(i);
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "OrganizationName": {
                    organization.setOrganizationName(this.getOrganizationName(child));
                    continue block10;
                }
                case "OrganizationDisplayName": {
                    organization.setOrganizationDisplayName(this.getOrganizationDisplayName(child));
                    continue block10;
                }
                case "OrganizationURL": {
                    organization.setOrganizationURL(this.getOrganizationURL(child));
                    continue block10;
                }
                default: {
                    this.logNode(child);
                }
            }
        }
        return organization;
    }

    private OrganizationDisplayName getOrganizationDisplayName(Node organizationDisplayNameNode) {
        return OrganizationDisplayName.builder().lang(XMLParser.getAttributeValue(organizationDisplayNameNode, "xml:lang")).value(organizationDisplayNameNode.getTextContent()).build();
    }

    private OrganizationURL getOrganizationURL(Node organizationURLNode) {
        return OrganizationURL.builder().lang(XMLParser.getAttributeValue(organizationURLNode, "xml:lang")).value(organizationURLNode.getTextContent()).build();
    }

    private OrganizationName getOrganizationName(Node organizationNameNode) {
        return OrganizationName.builder().lang(XMLParser.getAttributeValue(organizationNameNode, "xml:lang")).value(organizationNameNode.getTextContent()).build();
    }

    private SPSSODescriptor getSPSSODescriptor(Node spssoDescriptorrNode) {
        SPSSODescriptor spssoDescriptor = SPSSODescriptor.builder().authnRequestsSigned(XMLParser.getAttributeValue(spssoDescriptorrNode, "AuthnRequestsSigned")).wantAssertionsSigned(XMLParser.getAttributeValue(spssoDescriptorrNode, "WantAssertionsSigned")).protocolSupportEnumeration(XMLParser.getAttributeValue(spssoDescriptorrNode, "protocolSupportEnumeration")).build();
        block10: for (int i = 0; i < spssoDescriptorrNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = spssoDescriptorrNode.getChildNodes().item(i);
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "SingleLogoutService": {
                    spssoDescriptor.setSingleLogoutService(this.getSingleLogoutService(child));
                    continue block10;
                }
                case "NameIDFormat": {
                    spssoDescriptor.setNameIDFormat(child.getTextContent());
                    continue block10;
                }
                case "AssertionConsumerService": {
                    spssoDescriptor.setAssertionConsumerService(this.getAssertionConsumerService(child));
                    continue block10;
                }
                default: {
                    this.logNode(child);
                }
            }
        }
        return spssoDescriptor;
    }

    private AssertionConsumerService getAssertionConsumerService(Node sssertionConsumerServiceNode) {
        return AssertionConsumerService.builder().binding(XMLParser.getAttributeValue(sssertionConsumerServiceNode, "Binding")).location(XMLParser.getAttributeValue(sssertionConsumerServiceNode, "Location")).index(XMLParser.getAttributeValue(sssertionConsumerServiceNode, "index")).build();
    }

    private SingleLogoutService getSingleLogoutService(Node singleLogoutServiceNode) {
        return SingleLogoutService.builder().binding(XMLParser.getAttributeValue(singleLogoutServiceNode, "Binding")).location(XMLParser.getAttributeValue(singleLogoutServiceNode, "Location")).build();
    }

    private Signature getSignatureInstance(Node signatureNode) {
        Signature signature = Signature.builder().build();
        block10: for (int i = 0; i < signatureNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = signatureNode.getChildNodes().item(i);
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "SignedInfo": {
                    signature.setSignedInfo(this.getSignedInfo(child));
                    continue block10;
                }
                case "SignatureValue": {
                    signature.setSignatureValue(child.getTextContent());
                    continue block10;
                }
                case "KeyInfo": {
                    signature.setKeyInfo(this.getKeyInfo(child));
                    continue block10;
                }
                default: {
                    this.logNode(child);
                }
            }
        }
        return signature;
    }

    private KeyInfo getKeyInfo(Node keyInfoNode) {
        KeyInfo keyInfo = KeyInfo.builder().build();
        for (int i = 0; i < keyInfoNode.getChildNodes().getLength(); ++i) {
            Node child = keyInfoNode.getChildNodes().item(i);
            String nodeName = XMLParser.stripNameSpace(child.getNodeName());
            if ("X509Data".equals(nodeName)) {
                keyInfo.setX509Data(this.getX509Data(child));
                continue;
            }
            this.logNode(child);
        }
        return keyInfo;
    }

    private X509Data getX509Data(Node x509DataNode) {
        return X509Data.builder().x509Certificate(StringUtils.trimToNull((String)x509DataNode.getTextContent())).build();
    }

    private SignedInfo getSignedInfo(Node signedInfoNode) {
        SignedInfo signedInfo = SignedInfo.builder().build();
        block10: for (int i = 0; i < signedInfoNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = signedInfoNode.getChildNodes().item(i);
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "CanonicalizationMethod": {
                    signedInfo.setCanonicalizationMethod(this.getCanonicalizationMethod(child));
                    continue block10;
                }
                case "SignatureMethod": {
                    signedInfo.setSignatureMethod(this.getSignatureMethod(child));
                    continue block10;
                }
                case "Reference": {
                    signedInfo.setReference(this.getReference(child));
                    continue block10;
                }
                default: {
                    this.logNode(child);
                }
            }
        }
        return signedInfo;
    }

    private Reference getReference(Node referenceNode) {
        Reference reference = Reference.builder().uRI(XMLParser.getAttributeValue(referenceNode, "URI")).build();
        block10: for (int i = 0; i < referenceNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = referenceNode.getChildNodes().item(i);
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "Transforms": {
                    reference.setTransforms(this.getTransforms(child));
                    continue block10;
                }
                case "DigestMethod": {
                    reference.setDigestMethod(this.getDigestMethod(child));
                    continue block10;
                }
                case "DigestValue": {
                    reference.setDigestValue(child.getTextContent());
                    continue block10;
                }
                default: {
                    this.logNode(child);
                }
            }
        }
        return reference;
    }

    private DigestMethod getDigestMethod(Node digestMethodNode) {
        return DigestMethod.builder().algorithm(XMLParser.getAttributeValue(digestMethodNode, "Algorithm")).build();
    }

    private Transforms getTransforms(Node transformsNode) {
        Transforms transforms = Transforms.builder().transform(new ArrayList<Transform>()).build();
        for (int i = 0; i < transformsNode.getChildNodes().getLength(); ++i) {
            Node child = transformsNode.getChildNodes().item(i);
            String nodeName = XMLParser.stripNameSpace(child.getNodeName());
            if (!"Transform".equals(nodeName)) continue;
            transforms.getTransform().add(Transform.builder().algorithm(XMLParser.getAttributeValue(child, "Algorithm")).build());
        }
        return transforms;
    }

    private SignatureMethod getSignatureMethod(Node signatureMethodNode) {
        return SignatureMethod.builder().algorithm(XMLParser.getAttributeValue(signatureMethodNode, "Algorithm")).build();
    }

    private CanonicalizationMethod getCanonicalizationMethod(Node canonicalizationMethodNode) {
        return CanonicalizationMethod.builder().algorithm(XMLParser.getAttributeValue(canonicalizationMethodNode, "Algorithm")).build();
    }

    @Override
    public IDPMetaData parseIDPMetaData(InputStream xml) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document xmlDocument = dBuilder.parse(xml);
            IDPMetaData idpMetaData = IDPMetaData.builder().entityID(XMLParser.getAttributeValue(xmlDocument.getFirstChild(), "entityID")).validUntil(XMLParser.getAttributeValue(xmlDocument.getFirstChild(), "validUntil")).cacheDuration(XMLParser.getAttributeValue(xmlDocument.getFirstChild(), "cacheDuration")).iD(XMLParser.getAttributeValue(xmlDocument.getFirstChild(), "ID")).contactPerson(new ArrayList<ContactPerson>()).roleDescriptor(new ArrayList<RoleDescriptor>()).build();
            block16: for (int i = 0; i < xmlDocument.getFirstChild().getChildNodes().getLength(); ++i) {
                String nodeName;
                Node child = xmlDocument.getFirstChild().getChildNodes().item(i);
                switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                    case "Signature": {
                        idpMetaData.setSignature(this.getSignatureInstance(child));
                        continue block16;
                    }
                    case "IDPSSODescriptor": {
                        idpMetaData.setIDPSSODescriptor(this.getIDPSSODescriptor(child));
                        continue block16;
                    }
                    case "Organization": {
                        idpMetaData.setOrganization(this.getOrganization(child));
                        continue block16;
                    }
                    case "ContactPerson": {
                        idpMetaData.getContactPerson().add(this.getContactPerson(child));
                        continue block16;
                    }
                    case "RoleDescriptor": {
                        idpMetaData.getRoleDescriptor().add(this.getRoleDescriptor(child));
                        continue block16;
                    }
                    default: {
                        this.logNode(child);
                    }
                }
            }
            return idpMetaData;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.LOGGER.error("Unable ot parse the document due to error", (Throwable)e);
            throw new RuntimeException("Unable ot parse the document due to error", e);
        }
    }

    @Override
    public EntityDescriptorType parseMetadata(InputStream xml) {
        return XMLParser.parseXML(xml);
    }

    private RoleDescriptor getRoleDescriptor(Node roleDescriptorNode) {
        RoleDescriptor roleDescriptor = RoleDescriptor.builder().type(XMLParser.getAttributeValue(roleDescriptorNode, "type")).protocolSupportEnumeration(XMLParser.getAttributeValue(roleDescriptorNode, "protocolSupportEnumeration")).build();
        block16: for (int i = 0; i < roleDescriptorNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = roleDescriptorNode.getChildNodes().item(i);
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "KeyDescriptor": {
                    roleDescriptor.setKeyDescriptor(this.getKeyDescriptor(child));
                    continue block16;
                }
                case "ClaimTypesOffered": {
                    roleDescriptor.setClaimTypesOffered(this.getClaimTypesOffered(child));
                    continue block16;
                }
                case "SecurityTokenServiceEndpoint": {
                    roleDescriptor.setSecurityTokenServiceEndpoint(this.getSecurityTokenServiceEndpoint(child));
                    continue block16;
                }
                case "PassiveRequestorEndpoint": {
                    roleDescriptor.setPassiveRequestorEndpoint(this.getPassiveRequestorEndpoint(child));
                    continue block16;
                }
                case "TargetScopes": {
                    roleDescriptor.setTargetScopes(this.getTargetScopes(child));
                    continue block16;
                }
                case "ApplicationServiceEndpoint": {
                    roleDescriptor.setApplicationServiceEndpoint(this.getApplicationServiceEndpoint(child));
                    continue block16;
                }
                default: {
                    this.logNode(child);
                }
            }
        }
        return roleDescriptor;
    }

    private ApplicationServiceEndpoint getApplicationServiceEndpoint(Node applicationServiceEndpointNode) {
        ApplicationServiceEndpoint applicationServiceEndpoint = ApplicationServiceEndpoint.builder().build();
        block6: for (int i = 0; i < applicationServiceEndpointNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = applicationServiceEndpointNode.getChildNodes().item(i);
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "EndpointReference": {
                    applicationServiceEndpoint.setEndpointReference(this.getEndpointReference(child));
                    continue block6;
                }
                default: {
                    this.logNode(child);
                }
            }
        }
        return applicationServiceEndpoint;
    }

    private TargetScopes getTargetScopes(Node targetScopesNode) {
        TargetScopes targetScopes = TargetScopes.builder().build();
        block6: for (int i = 0; i < targetScopesNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = targetScopesNode.getChildNodes().item(i);
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "EndpointReference": {
                    targetScopes.setEndpointReference(this.getEndpointReference(child));
                    continue block6;
                }
                default: {
                    this.logNode(child);
                }
            }
        }
        return targetScopes;
    }

    private PassiveRequestorEndpoint getPassiveRequestorEndpoint(Node passiveRequestorEndpointNode) {
        PassiveRequestorEndpoint passiveRequestorEndpoint = PassiveRequestorEndpoint.builder().build();
        block6: for (int i = 0; i < passiveRequestorEndpointNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = passiveRequestorEndpointNode.getChildNodes().item(i);
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "EndpointReference": {
                    passiveRequestorEndpoint.setEndpointReference(this.getEndpointReference(child));
                    continue block6;
                }
                default: {
                    this.logNode(child);
                }
            }
        }
        return passiveRequestorEndpoint;
    }

    private SecurityTokenServiceEndpoint getSecurityTokenServiceEndpoint(Node securityTokenServiceEndpointNode) {
        SecurityTokenServiceEndpoint securityTokenServiceEndpoint = SecurityTokenServiceEndpoint.builder().build();
        block6: for (int i = 0; i < securityTokenServiceEndpointNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = securityTokenServiceEndpointNode.getChildNodes().item(i);
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "EndpointReference": {
                    securityTokenServiceEndpoint.setEndpointReference(this.getEndpointReference(child));
                    continue block6;
                }
                default: {
                    this.logNode(child);
                }
            }
        }
        return securityTokenServiceEndpoint;
    }

    private EndpointReference getEndpointReference(Node endpointReferenceNode) {
        EndpointReference endpointReference = EndpointReference.builder().build();
        block6: for (int i = 0; i < endpointReferenceNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = endpointReferenceNode.getChildNodes().item(i);
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "Address": {
                    endpointReference.setAddress(child.getTextContent());
                    continue block6;
                }
                default: {
                    this.logNode(child);
                }
            }
        }
        return endpointReference;
    }

    private ClaimTypesOffered getClaimTypesOffered(Node claimTypesOfferedNode) {
        ClaimTypesOffered claimTypesOffered = ClaimTypesOffered.builder().claimType(new ArrayList<ClaimType>()).build();
        block6: for (int i = 0; i < claimTypesOfferedNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = claimTypesOfferedNode.getChildNodes().item(i);
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "ClaimType": {
                    claimTypesOffered.getClaimType().add(this.getClaimType(child));
                    continue block6;
                }
                default: {
                    this.logNode(child);
                }
            }
        }
        return claimTypesOffered;
    }

    private ClaimType getClaimType(Node claimTypeNode) {
        ClaimType claimType = ClaimType.builder().uri(XMLParser.getAttributeValue(claimTypeNode, "Uri")).build();
        block8: for (int i = 0; i < claimTypeNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = claimTypeNode.getChildNodes().item(i);
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "Description": {
                    claimType.setDescription(child.getTextContent());
                    continue block8;
                }
                case "DisplayName": {
                    claimType.setDisplayName(child.getTextContent());
                    continue block8;
                }
                default: {
                    this.logNode(child);
                }
            }
        }
        return claimType;
    }

    private IDPSSODescriptor getIDPSSODescriptor(Node idpSSODescriptorNode) {
        IDPSSODescriptor idpssoDescriptor = IDPSSODescriptor.builder().wantAuthnRequestsSigned(XMLParser.getAttributeValue(idpSSODescriptorNode, "WantAuthnRequestsSigned")).protocolSupportEnumeration(XMLParser.getAttributeValue(idpSSODescriptorNode, "protocolSupportEnumeration")).keyDescriptor(new ArrayList<KeyDescriptor>()).build();
        block12: for (int i = 0; i < idpSSODescriptorNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = idpSSODescriptorNode.getChildNodes().item(i);
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "SingleLogoutService": {
                    idpssoDescriptor.setSingleLogoutService(this.getSingleLogoutService(child));
                    continue block12;
                }
                case "NameIDFormat": {
                    idpssoDescriptor.setNameIDFormat(child.getTextContent());
                    continue block12;
                }
                case "SingleSignOnService": {
                    idpssoDescriptor.setSingleSignOnService(this.getSingleSignOnService(child));
                    continue block12;
                }
                case "KeyDescriptor": {
                    idpssoDescriptor.getKeyDescriptor().add(this.getKeyDescriptor(child));
                    continue block12;
                }
                default: {
                    this.logNode(child);
                }
            }
        }
        return idpssoDescriptor;
    }

    private KeyDescriptor getKeyDescriptor(Node keyDescriptorNode) {
        KeyDescriptor keyDescriptor = KeyDescriptor.builder().use(XMLParser.getAttributeValue(keyDescriptorNode, "use")).build();
        for (int i = 0; i < keyDescriptorNode.getChildNodes().getLength(); ++i) {
            Node child = keyDescriptorNode.getChildNodes().item(i);
            String nodeName = XMLParser.stripNameSpace(child.getNodeName());
            if ("KeyInfo".equals(nodeName)) {
                keyDescriptor.setKeyInfo(this.getKeyInfo(child));
                continue;
            }
            this.logNode(child);
        }
        return keyDescriptor;
    }

    private void logNode(Node child) {
        List<String> ignored = List.of("#text", "#comment");
        if (!ignored.contains(child.getNodeName())) {
            this.LOGGER.warn("Unmatched:{} -> {}", (Object)XMLParser.getXPath(child), (Object)child.getNodeValue());
        }
    }

    private SingleSignOnService getSingleSignOnService(Node singleSignOnServiceNode) {
        return SingleSignOnService.builder().binding(XMLParser.getAttributeValue(singleSignOnServiceNode, "Binding")).location(XMLParser.getAttributeValue(singleSignOnServiceNode, "Location")).build();
    }
}

