/*
 * Decompiled with CFR 0.152.
 */
package io.vpv.saml.metadata.model;

import io.vpv.saml.metadata.model.DigestMethod;
import io.vpv.saml.metadata.model.Transforms;

public class Reference {
    public String uRI;
    public Transforms transforms;
    public DigestMethod digestMethod;
    public String digestValue;

    Reference(String uRI, Transforms transforms, DigestMethod digestMethod, String digestValue) {
        this.uRI = uRI;
        this.transforms = transforms;
        this.digestMethod = digestMethod;
        this.digestValue = digestValue;
    }

    public static ReferenceBuilder builder() {
        return new ReferenceBuilder();
    }

    public void setURI(String uRI) {
        this.uRI = uRI;
    }

    public void setTransforms(Transforms transforms) {
        this.transforms = transforms;
    }

    public void setDigestMethod(DigestMethod digestMethod) {
        this.digestMethod = digestMethod;
    }

    public void setDigestValue(String digestValue) {
        this.digestValue = digestValue;
    }

    public String getURI() {
        return this.uRI;
    }

    public Transforms getTransforms() {
        return this.transforms;
    }

    public DigestMethod getDigestMethod() {
        return this.digestMethod;
    }

    public String getDigestValue() {
        return this.digestValue;
    }

    public String toString() {
        return "Reference(uRI=" + this.getURI() + ", transforms=" + this.getTransforms() + ", digestMethod=" + this.getDigestMethod() + ", digestValue=" + this.getDigestValue() + ")";
    }

    public static class ReferenceBuilder {
        private String uRI;
        private Transforms transforms;
        private DigestMethod digestMethod;
        private String digestValue;

        ReferenceBuilder() {
        }

        public ReferenceBuilder uRI(String uRI) {
            this.uRI = uRI;
            return this;
        }

        public ReferenceBuilder transforms(Transforms transforms) {
            this.transforms = transforms;
            return this;
        }

        public ReferenceBuilder digestMethod(DigestMethod digestMethod) {
            this.digestMethod = digestMethod;
            return this;
        }

        public ReferenceBuilder digestValue(String digestValue) {
            this.digestValue = digestValue;
            return this;
        }

        public Reference build() {
            return new Reference(this.uRI, this.transforms, this.digestMethod, this.digestValue);
        }

        public String toString() {
            return "Reference.ReferenceBuilder(uRI=" + this.uRI + ", transforms=" + this.transforms + ", digestMethod=" + this.digestMethod + ", digestValue=" + this.digestValue + ")";
        }
    }
}

