/*
 * Decompiled with CFR 0.152.
 */
package io.vpv.saml.metadata.service;

import io.vpv.saml.metadata.model.AssertionConsumerService;
import io.vpv.saml.metadata.model.CanonicalizationMethod;
import io.vpv.saml.metadata.model.ContactPerson;
import io.vpv.saml.metadata.model.DigestMethod;
import io.vpv.saml.metadata.model.IDPMetaData;
import io.vpv.saml.metadata.model.IDPSSODescriptor;
import io.vpv.saml.metadata.model.KeyDescriptor;
import io.vpv.saml.metadata.model.KeyInfo;
import io.vpv.saml.metadata.model.Organization;
import io.vpv.saml.metadata.model.OrganizationDisplayName;
import io.vpv.saml.metadata.model.OrganizationName;
import io.vpv.saml.metadata.model.OrganizationURL;
import io.vpv.saml.metadata.model.Reference;
import io.vpv.saml.metadata.model.SPMetaData;
import io.vpv.saml.metadata.model.SPSSODescriptor;
import io.vpv.saml.metadata.model.Signature;
import io.vpv.saml.metadata.model.SignatureMethod;
import io.vpv.saml.metadata.model.SignedInfo;
import io.vpv.saml.metadata.model.SingleLogoutService;
import io.vpv.saml.metadata.model.SingleSignOnService;
import io.vpv.saml.metadata.model.Transform;
import io.vpv.saml.metadata.model.Transforms;
import io.vpv.saml.metadata.model.X509Data;
import io.vpv.saml.metadata.service.MetaDataParser;
import io.vpv.saml.metadata.util.XMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MetaDataParserImpl
implements MetaDataParser {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    @Override
    public SPMetaData parseSPMetadata(InputStream xml) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document xmlDocument = dBuilder.parse(xml);
            SPMetaData spMetaData = SPMetaData.builder().entityID(XMLParser.getAttributeValue(xmlDocument.getFirstChild(), "entityID")).validUntil(XMLParser.getAttributeValue(xmlDocument.getFirstChild(), "validUntil")).cacheDuration(XMLParser.getAttributeValue(xmlDocument.getFirstChild(), "cacheDuration")).iD(XMLParser.getAttributeValue(xmlDocument.getFirstChild(), "ID")).contactPerson(new ArrayList<ContactPerson>()).build();
            block14: for (int i = 0; i < xmlDocument.getFirstChild().getChildNodes().getLength(); ++i) {
                String nodeName;
                Node child = xmlDocument.getFirstChild().getChildNodes().item(i);
                this.LOGGER.debug(child.getNodeName() + "->'" + child.getNodeValue() + "'");
                switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                    case "Signature": {
                        spMetaData.setSignature(this.getSignatureInstance(child));
                        continue block14;
                    }
                    case "SPSSODescriptor": {
                        spMetaData.setSPSSODescriptor(this.getSPSSODescriptor(child));
                        continue block14;
                    }
                    case "Organization": {
                        spMetaData.setOrganization(this.getOrganization(child));
                        continue block14;
                    }
                    case "ContactPerson": {
                        spMetaData.getContactPerson().add(this.getContactPerson(child));
                    }
                }
            }
            return spMetaData;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.LOGGER.error("Unable ot parse the document due to error", (Throwable)e);
            throw new RuntimeException("Unable ot parse the document due to error", e);
        }
    }

    private ContactPerson getContactPerson(Node contactPersonNode) {
        ContactPerson contactPerson = ContactPerson.builder().contactType(contactPersonNode.getAttributes().getNamedItem("contactType").getNodeValue()).build();
        block8: for (int i = 0; i < contactPersonNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = contactPersonNode.getChildNodes().item(i);
            this.LOGGER.debug(child.getNodeName() + "->'" + child.getNodeValue() + "'");
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "GivenName": {
                    contactPerson.setGivenName(child.getTextContent());
                    continue block8;
                }
                case "EmailAddress": {
                    contactPerson.setEmailAddress(child.getTextContent());
                }
            }
        }
        return contactPerson;
    }

    private Organization getOrganization(Node organizationNode) {
        Organization organization = Organization.builder().build();
        block10: for (int i = 0; i < organizationNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = organizationNode.getChildNodes().item(i);
            this.LOGGER.debug(child.getNodeName() + "->'" + child.getNodeValue() + "'");
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "OrganizationName": {
                    organization.setOrganizationName(this.getOrganizationName(child));
                    continue block10;
                }
                case "OrganizationDisplayName": {
                    organization.setOrganizationDisplayName(this.getOrganizationDisplayName(child));
                    continue block10;
                }
                case "OrganizationURL": {
                    organization.setOrganizationURL(this.getOrganizationURL(child));
                }
            }
        }
        return organization;
    }

    private OrganizationDisplayName getOrganizationDisplayName(Node organizationDisplayNameNode) {
        return OrganizationDisplayName.builder().lang(organizationDisplayNameNode.getAttributes().getNamedItem("xml:lang").getNodeValue()).value(organizationDisplayNameNode.getTextContent()).build();
    }

    private OrganizationURL getOrganizationURL(Node organizationURLNode) {
        return OrganizationURL.builder().lang(organizationURLNode.getAttributes().getNamedItem("xml:lang").getNodeValue()).value(organizationURLNode.getTextContent()).build();
    }

    private OrganizationName getOrganizationName(Node organizationNameNode) {
        return OrganizationName.builder().lang(organizationNameNode.getAttributes().getNamedItem("xml:lang").getNodeValue()).value(organizationNameNode.getTextContent()).build();
    }

    private SPSSODescriptor getSPSSODescriptor(Node spssoDescriptorrNode) {
        SPSSODescriptor spssoDescriptor = SPSSODescriptor.builder().authnRequestsSigned(spssoDescriptorrNode.getAttributes().getNamedItem("AuthnRequestsSigned").getNodeValue()).wantAssertionsSigned(spssoDescriptorrNode.getAttributes().getNamedItem("WantAssertionsSigned").getNodeValue()).protocolSupportEnumeration(spssoDescriptorrNode.getAttributes().getNamedItem("protocolSupportEnumeration").getNodeValue()).build();
        block10: for (int i = 0; i < spssoDescriptorrNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = spssoDescriptorrNode.getChildNodes().item(i);
            this.LOGGER.debug(child.getNodeName() + "->'" + child.getNodeValue() + "'");
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "SingleLogoutService": {
                    spssoDescriptor.setSingleLogoutService(this.getSingleLogoutService(child));
                    continue block10;
                }
                case "NameIDFormat": {
                    spssoDescriptor.setNameIDFormat(child.getTextContent());
                    continue block10;
                }
                case "AssertionConsumerService": {
                    spssoDescriptor.setAssertionConsumerService(this.getAssertionConsumerService(child));
                }
            }
        }
        return spssoDescriptor;
    }

    private AssertionConsumerService getAssertionConsumerService(Node sssertionConsumerServiceNode) {
        return AssertionConsumerService.builder().binding(sssertionConsumerServiceNode.getAttributes().getNamedItem("Binding").getNodeValue()).location(sssertionConsumerServiceNode.getAttributes().getNamedItem("Location").getNodeValue()).index(sssertionConsumerServiceNode.getAttributes().getNamedItem("index").getNodeValue()).build();
    }

    private SingleLogoutService getSingleLogoutService(Node singleLogoutServiceNode) {
        return SingleLogoutService.builder().binding(singleLogoutServiceNode.getAttributes().getNamedItem("Binding").getNodeValue()).location(singleLogoutServiceNode.getAttributes().getNamedItem("Location").getNodeValue()).build();
    }

    private Signature getSignatureInstance(Node signatureNode) {
        Signature signature = Signature.builder().build();
        block10: for (int i = 0; i < signatureNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = signatureNode.getChildNodes().item(i);
            this.LOGGER.debug(child.getNodeName() + "->'" + child.getNodeValue() + "'");
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "SignedInfo": {
                    signature.setSignedInfo(this.getSignedInfo(child));
                    continue block10;
                }
                case "SignatureValue": {
                    signature.setSignatureValue(child.getTextContent());
                    continue block10;
                }
                case "KeyInfo": {
                    signature.setKeyInfo(this.getKeyInfo(child));
                }
            }
        }
        return signature;
    }

    private KeyInfo getKeyInfo(Node keyInfoNode) {
        KeyInfo keyInfo = KeyInfo.builder().build();
        for (int i = 0; i < keyInfoNode.getChildNodes().getLength(); ++i) {
            Node child = keyInfoNode.getChildNodes().item(i);
            this.LOGGER.debug(child.getNodeName() + "->'" + child.getNodeValue() + "'");
            String nodeName = XMLParser.stripNameSpace(child.getNodeName());
            if (!"X509Data".equals(nodeName)) continue;
            keyInfo.setX509Data(this.getX509Data(child));
        }
        return keyInfo;
    }

    private X509Data getX509Data(Node x509DataNode) {
        return X509Data.builder().x509Certificate(StringUtils.trimToNull((String)x509DataNode.getTextContent())).build();
    }

    private SignedInfo getSignedInfo(Node signedInfoNode) {
        SignedInfo signedInfo = SignedInfo.builder().build();
        block10: for (int i = 0; i < signedInfoNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = signedInfoNode.getChildNodes().item(i);
            this.LOGGER.debug(child.getNodeName() + "->'" + child.getNodeValue() + "'");
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "CanonicalizationMethod": {
                    signedInfo.setCanonicalizationMethod(this.getCanonicalizationMethod(child));
                    continue block10;
                }
                case "SignatureMethod": {
                    signedInfo.setSignatureMethod(this.getSignatureMethod(child));
                    continue block10;
                }
                case "Reference": {
                    signedInfo.setReference(this.getReference(child));
                }
            }
        }
        return signedInfo;
    }

    private Reference getReference(Node referenceNode) {
        Reference reference = Reference.builder().uRI(referenceNode.getAttributes().getNamedItem("URI").getNodeValue()).build();
        block10: for (int i = 0; i < referenceNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = referenceNode.getChildNodes().item(i);
            this.LOGGER.debug(child.getNodeName() + "->'" + child.getNodeValue() + "'");
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "Transforms": {
                    reference.setTransforms(this.getTransforms(child));
                    continue block10;
                }
                case "DigestMethod": {
                    reference.setDigestMethod(this.getDigestMethod(child));
                    continue block10;
                }
                case "DigestValue": {
                    reference.setDigestValue(child.getTextContent());
                }
            }
        }
        return reference;
    }

    private DigestMethod getDigestMethod(Node digestMethodNode) {
        return DigestMethod.builder().algorithm(digestMethodNode.getAttributes().getNamedItem("Algorithm").getNodeValue()).build();
    }

    private Transforms getTransforms(Node transformsNode) {
        Transforms transforms = Transforms.builder().transform(new ArrayList<Transform>()).build();
        for (int i = 0; i < transformsNode.getChildNodes().getLength(); ++i) {
            Node child = transformsNode.getChildNodes().item(i);
            this.LOGGER.debug(child.getNodeName() + "->'" + child.getNodeValue() + "'");
            String nodeName = XMLParser.stripNameSpace(child.getNodeName());
            if (!"Transform".equals(nodeName)) continue;
            transforms.getTransform().add(Transform.builder().algorithm(child.getAttributes().getNamedItem("Algorithm").getNodeValue()).build());
        }
        return transforms;
    }

    private SignatureMethod getSignatureMethod(Node signatureMethodNode) {
        return SignatureMethod.builder().algorithm(signatureMethodNode.getAttributes().getNamedItem("Algorithm").getNodeValue()).build();
    }

    private CanonicalizationMethod getCanonicalizationMethod(Node canonicalizationMethodNode) {
        return CanonicalizationMethod.builder().algorithm(canonicalizationMethodNode.getAttributes().getNamedItem("Algorithm").getNodeValue()).build();
    }

    @Override
    public IDPMetaData parseIDPMetaData(InputStream xml) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document xmlDocument = dBuilder.parse(xml);
            IDPMetaData idpMetaData = IDPMetaData.builder().entityID(XMLParser.getAttributeValue(xmlDocument.getFirstChild(), "entityID")).validUntil(XMLParser.getAttributeValue(xmlDocument.getFirstChild(), "validUntil")).cacheDuration(XMLParser.getAttributeValue(xmlDocument.getFirstChild(), "cacheDuration")).iD(XMLParser.getAttributeValue(xmlDocument.getFirstChild(), "ID")).contactPerson(new ArrayList<ContactPerson>()).build();
            block14: for (int i = 0; i < xmlDocument.getFirstChild().getChildNodes().getLength(); ++i) {
                String nodeName;
                Node child = xmlDocument.getFirstChild().getChildNodes().item(i);
                this.LOGGER.debug(child.getNodeName() + "->'" + child.getNodeValue() + "'");
                switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                    case "Signature": {
                        idpMetaData.setSignature(this.getSignatureInstance(child));
                        continue block14;
                    }
                    case "IDPSSODescriptor": {
                        idpMetaData.setIDPSSODescriptor(this.getIDPSSODescriptor(child));
                        continue block14;
                    }
                    case "Organization": {
                        idpMetaData.setOrganization(this.getOrganization(child));
                        continue block14;
                    }
                    case "ContactPerson": {
                        idpMetaData.getContactPerson().add(this.getContactPerson(child));
                    }
                }
            }
            return idpMetaData;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.LOGGER.error("Unable ot parse the document due to error", (Throwable)e);
            throw new RuntimeException("Unable ot parse the document due to error", e);
        }
    }

    private IDPSSODescriptor getIDPSSODescriptor(Node idpSSODescriptorNode) {
        IDPSSODescriptor idpssoDescriptor = IDPSSODescriptor.builder().wantAuthnRequestsSigned(idpSSODescriptorNode.getAttributes().getNamedItem("WantAuthnRequestsSigned").getNodeValue()).protocolSupportEnumeration(idpSSODescriptorNode.getAttributes().getNamedItem("protocolSupportEnumeration").getNodeValue()).keyDescriptor(new ArrayList<KeyDescriptor>()).build();
        block12: for (int i = 0; i < idpSSODescriptorNode.getChildNodes().getLength(); ++i) {
            String nodeName;
            Node child = idpSSODescriptorNode.getChildNodes().item(i);
            this.LOGGER.debug(child.getNodeName() + "->'" + child.getNodeValue() + "'");
            switch (nodeName = XMLParser.stripNameSpace(child.getNodeName())) {
                case "SingleLogoutService": {
                    idpssoDescriptor.setSingleLogoutService(this.getSingleLogoutService(child));
                    continue block12;
                }
                case "NameIDFormat": {
                    idpssoDescriptor.setNameIDFormat(child.getTextContent());
                    continue block12;
                }
                case "SingleSignOnService": {
                    idpssoDescriptor.setSingleSignOnService(this.getSingleSignOnService(child));
                    continue block12;
                }
                case "KeyDescriptor": {
                    idpssoDescriptor.getKeyDescriptor().add(this.getKeyDescriptor(child));
                }
            }
        }
        return idpssoDescriptor;
    }

    private KeyDescriptor getKeyDescriptor(Node keyDescriptorNode) {
        KeyDescriptor keyDescriptor = KeyDescriptor.builder().use(keyDescriptorNode.getAttributes().getNamedItem("use").getNodeValue()).build();
        for (int i = 0; i < keyDescriptorNode.getChildNodes().getLength(); ++i) {
            Node child = keyDescriptorNode.getChildNodes().item(i);
            this.LOGGER.debug(child.getNodeName() + "->'" + child.getNodeValue() + "'");
            String nodeName = XMLParser.stripNameSpace(child.getNodeName());
            if (!"KeyInfo".equals(nodeName)) continue;
            keyDescriptor.setKeyInfo(this.getKeyInfo(child));
        }
        return keyDescriptor;
    }

    private SingleSignOnService getSingleSignOnService(Node singleSignOnServiceNode) {
        return SingleSignOnService.builder().binding(singleSignOnServiceNode.getAttributes().getNamedItem("Binding").getNodeValue()).location(singleSignOnServiceNode.getAttributes().getNamedItem("Location").getNodeValue()).build();
    }
}

